
from django.shortcuts import render
from django.http import JsonResponse
from django.views.decorators.clickjacking import xframe_options_sameorigin
from django.views.decorators.csrf import csrf_exempt
from django.views.generic.base import TemplateView
from django.http import HttpResponse
from django.http import HttpResponseRedirect
from django.utils.safestring import mark_safe
from django.http import FileResponse

from django.db.models import Q
from iccircle import models
from django.conf import settings
import re

from urllib.parse import quote, unquote

import json
import base64
import subprocess
import time
import os

#--Begin of EMAIL ------------------------------------------------------
import smtplib
from email.mime.text import MIMEText
from email.mime.multipart import MIMEMultipart
from email.mime.application import MIMEApplication
from email.header import Header

mailhost = 'smtp.qiye.aliyun.com'
mailport = 465
mailuser = 'noreply@iccircle.com'
mailpass = 'xsYVjiyZ0UE6slIO'
mailfrom = 'noreply@iccircle.com'


def sendmail(mailto, subject, body, tarfiles=[], cc=[]):
    msg = MIMEMultipart()
    msg['From'] = mailfrom
    #print('From: ' + msg['From'])
    msg['To'] = ','.join(mailto)
    #print('To: ' + msg['To'])

    if len(cc) != 0:
        msg['Cc'] = ','.join(cc)
        #print('Cc: ' + msg['Cc'])
          
    msg['Subject'] = subject
    #print('Subject: ' + msg['Subject'])
          
    msg.attach(MIMEText(body, 'plain'))
    #print('Body: ...')
    
    for tarfile in tarfiles:
        # read attach file
        attachfile = MIMEApplication(open(tarfile, 'rb').read())
        #print('Attach: ' + os.path.basename(tarfile))
        attachfile.add_header(
            'Content-Disposition',
            'attachment',
            filename=os.path.basename(tarfile)
        )
        
        # overwrite default attach content type
        m = re.search(r'(\..*)$', tarfile)
        if m:
            fileext = m.group(1)
            if fileext in ['.tar.gz', '.tgz', '.gz']:
                attachfile.add_header('Content-Type', 'application/gzip')
            elif fileext in ['.tar']:
                attachfile.add_header('Content-Type', 'application/x-tar')
            elif fileext in ['.zip']:
                attachfile.add_header('Content-Type', 'application/zip')
            elif fileext in ['.pdf']:
                attachfile.add_header('Content-Type', 'application/pdf')
                
        # attach file
        msg.attach(attachfile)

    try:
        mailserver = smtplib.SMTP_SSL(host=mailhost, port=mailport)
        # mailserver.set_debuglevel(1)
        mailserver.ehlo()
        mailserver.login(mailuser, mailpass)
     
        mailserver.sendmail(mailfrom, mailto, msg.as_string())
        mailserver.quit()

        #print('Done!')
    except Exception as e:
        print(e)
        return False

    return True

#--End of EMAIL -----------------------------------------------------------------

#--Begin of SMS -----------------------------------------------------------------
from alibabacloud_dysmsapi20180501.client import Client as Dysmsapi20180501Client
from alibabacloud_credentials.client import Client as CredentialClient
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_dysmsapi20180501 import models as dysmsapi_20180501_models
from alibabacloud_tea_util import models as util_models
from alibabacloud_tea_util.client import Client as UtilClient


#--End of SMS -------------------------------------------------------------------

def adstxt(request):
    ads_txt = [
        "google.com, pub-1481873596446391, DIRECT, f08c47fec0942fa0"
    ]
    
    return HttpResponse('\n'.join(ads_txt), content_type="text/plain;charset=utf-8")


def robots(request):
    robots_txt = [
        "User-agent: MJ12bot",
        "Disallow: /",
        "",
        "User-agent: PetalBot",
        "Disallow: /",
        "",
        "User-Agent: *",
        "Disallow: /editor",
        "Sitemap: https://iccircle.com/sitemap.xml"
    ]
    
    return HttpResponse('\n'.join(robots_txt), content_type="text/plain;charset=utf-8")


def OyiMLDeh2U(request):
    return HttpResponse('9d6727efbb86f244a52774872f7c5d4e', content_type="text/plain;charset=utf-8")


def xLgZI1o64B(request):
    return HttpResponse('18d2d8a50bda5065de97e873ac6d3976', content_type="text/plain;charset=utf-8")


def sitemap(request):
    data = {}

    data['kw_list'] = []
    
    data['wxname_list'] = []
    member = models.member.objects.filter(isdel=False)
    for row in member:
        data['wxname_list'].append(quote(row.name, 'utf-8'))
        
    data['year_list'] = ['2022', '2023', '2024']
    data['month_list'] = ['01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12']
    
    # column name list
    data['name_list'] = []
    records = models.columns.objects.filter(is_del=False)
    for row in records:
        item = {}
        item['name'] = quote(row.name, 'utf-8')
        item['updatedate'] = row.createdate
        data['name_list'].append(item)
    
    # column id list
    data['column_list'] = []
    records = models.article.objects.filter(isdel=False, isprivate=False)
    for row in records:
        item = {}
        item['id'] = row.id
        item['updatedate'] = row.modifydate
        data['column_list'].append(item)

    return render(request, 'sitemap_t.xml', data, content_type='application/xml;charset=utf-8')


def bingsiteauth(request):
    return render(request, 'BingSiteAuth.xml', content_type='application/xml;charset=utf-8')


@csrf_exempt
def send_verify_code(request):
    to = request.POST.get('to')
    code = request.POST.get('vcode')
    
    # call sendmail func
    if sendmail(mailto, subject, textbody):
        data = { 'msg': '验证码发送成功' }
    else:
        data = { 'msg': '请重新发送' }

    return JsonResponse(data, safe=False)


def thirdparty(request):
    data = {}
    
    return render(request, 'thirdparty.html', data)


def index(request):
    t = time.localtime(time.time())
    y = "{:0>4d}".format(t.tm_year)
    m = t.tm_mon
    
    member = models.member.objects.filter(isdel=False).order_by('?')
    data = {}
    gzh = []
    for row in member:
        item = {}
        item['name'] = row.name
        item['qrcode'] = row.qrcode
        item['intro'] = row.intro
        gzh.append(item)
    num = len(gzh)
    data = {
        'gzh': gzh,
        'num': num,
        'y': y,
        'm': m
    }

    return render(request, 'index.html', data)

def member(request):
    hot = request.GET.get('hot', '0')
    hot_val = int(hot)
    filter_dict = {}
    filter_dict['isdel'] = False
    filter_dict['hot__gte'] = hot_val
    member = models.member.objects.filter(**filter_dict).order_by('-hot', '?')
    #member = models.member.objects.filter(isdel=False).order_by('?')
    #member = models.member.objects.all().order_by('?')

    data = {}
    gzh = []
    for row in member:
        item = {}
        item['mid'] = row.mid
        item['name'] = row.name
        item['qrcode'] = row.qrcode
        item['intro'] = row.intro
        item['hot'] = row.hot

        #load author info
        author = models.author.objects.filter(mid=row.mid)
        data = {}
        if author.exists():
            data['empty'] = "no"
            data['author_id'] = author[0].author_id
            data['author_name'] = author[0].author_name
            data['intro'] = author[0].intro
            data['sph_name'] = author[0].sph_name
            data['sph_qrcode'] = author[0].sph_qrcode
            data['zsxq_name'] = author[0].zsxq_name
            data['zsxq_qrcode'] = author[0].zsxq_qrcode
            data['csdn_name'] = author[0].csdn_name
            data['csdn_url'] = author[0].csdn_url
            data['bili_name'] = author[0].bili_name
            data['bili_url'] = author[0].bili_url
            data['blog2_name'] = author[0].blog2_name
            data['blog2_url'] = author[0].blog2_url
            data['toutiao_name'] = author[0].toutiao_name
            data['toutiao_url'] = author[0].toutiao_url
            data['zhihu_name'] = author[0].zhihu_name
            data['zhihu_url'] = author[0].zhihu_url
            data['xhs_name'] = author[0].xhs_name
            data['xhs_url'] = author[0].xhs_url
            data['web_name'] = author[0].web_name
            data['web_url'] = author[0].web_url
            data['other_url1'] = author[0].other_url1
            data['other_url2'] = author[0].other_url2
        else:
            data['empty'] = "yes"

        item['no_addition'] = data['empty']
        item['addition_data'] = data
        gzh.append(item)
    num = len(gzh)
    data = {
        'gzh': gzh,
        'num': num
    }

    return render(request, 'member.html', data)

def member_del(request):
    isdel_val = request.GET.get('isdel', '0')
    if isdel_val == '1':
        member = models.member.objects.filter(isdel=True)
    else:
        member = models.member.objects.filter(isdel=False)

    data = {}
    gzh = []
    for row in member:
        item = {}
        item['mid'] = row.mid
        item['name'] = row.name
        item['isdel'] = row.isdel
        
        gzh.append(item)
    num = len(gzh)    
    data = {
        'gzh': gzh,
        'num': num
    }
    
    return render(request, 'member_del.html', data)

@csrf_exempt
def member_del_handle(request):
    mid = request.POST.get('mid')

    temp = models.member.objects.get(mid=mid)
    temp.isdel = True
    temp.save()
    
    data = {'msg': "delete successfully"}

    return JsonResponse(data, safe=False)

def member_add(request):
    data = {}
    return render(request, 'member_add.html', data)

@csrf_exempt
def member_add_handle(request):
    
    models.member.objects.create(
        name = request.POST.get('gzh_name'),
        qrcode = request.POST.get('gzh_qrcode_url'),
        intro = request.POST.get('gzh_intro')
    )

    data = {'msg': "add successfully"}

    return JsonResponse(data, safe=False)

def journal(request):
    y = request.GET.get('y')
    m = request.GET.get('m')
    kw = request.GET.get('kw')
    wxname = request.GET.get('wxname')

    # by wxname
    if not wxname == None:
        journal = models.journal.objects.filter(is_del=0)
    
        data = {}
        article = []
        tags_cnt = {
            'FPGA': 0,
            'frontend': 0,
            'verification': 0,
            'backend': 0,
            'embedded': 0,
            'automation': 0,
            'analog': 0,
            'jobs': 0,
            'management':0,
            'software': 0
        }

        for row in journal:
            # count tags
            if re.search('FPGA', row.keywords):
                tags_cnt['FPGA'] = tags_cnt['FPGA'] + 1
            if re.search('前端', row.keywords):
                tags_cnt['frontend'] = tags_cnt['frontend'] + 1
            if re.search('验证', row.keywords):
                tags_cnt['verification'] = tags_cnt['verification'] + 1
            if re.search('后端', row.keywords):
                tags_cnt['backend'] = tags_cnt['backend'] + 1
            if re.search('嵌入式', row.keywords):
                tags_cnt['embedded'] = tags_cnt['embedded'] + 1
            if re.search('自动化', row.keywords):
                tags_cnt['automation'] = tags_cnt['automation'] + 1
            if re.search('模拟', row.keywords):
                tags_cnt['analog'] = tags_cnt['analog'] + 1
            if re.search('求职就业', row.keywords):
                tags_cnt['jobs'] = tags_cnt['jobs'] + 1
            if re.search('管理', row.keywords):
                tags_cnt['management'] = tags_cnt['management'] + 1
            if re.search('软件', row.keywords):
                tags_cnt['software'] = tags_cnt['software'] + 1

            if re.search(wxname, row.wxname):
                item = {}
                item['id'] = row.id
                item['title'] = row.title
                item['keywords'] = row.keywords
                item['url'] = row.url
                item['wxname'] = row.wxname
                item['summary'] = row.summary
                article.append(item)

        member = models.member.objects.filter(name=wxname)
        gzh_qrcode = ''
        gzh_intro = ''
        for row in member:
            gzh_qrcode = row.qrcode
            gzh_intro = row.intro
        
        data = {
            'year': y,
            'month': m,
            'article': article,
            'tags_cnt': tags_cnt,
            'wxname': wxname,
            'gzh_qrcode': gzh_qrcode,
            'gzh_intro': gzh_intro
        }
    
        return render(request, 'journal_tag.html', data)

    # tag
    if y == None and m == None and not kw == None:
        journal = models.journal.objects.filter(is_del=0)
    
        data = {}
        article = []
        tags_cnt = {
            'FPGA': 0,
            'frontend': 0,
            'verification': 0,
            'backend': 0,
            'embedded': 0,
            'automation': 0,
            'analog': 0,
            'jobs': 0,
            'management':0,
            'software': 0
        }

        for row in journal:
            # count tags
            if re.search('FPGA', row.keywords):
                tags_cnt['FPGA'] = tags_cnt['FPGA'] + 1
            if re.search('前端', row.keywords):
                tags_cnt['frontend'] = tags_cnt['frontend'] + 1
            if re.search('验证', row.keywords):
                tags_cnt['verification'] = tags_cnt['verification'] + 1
            if re.search('后端', row.keywords):
                tags_cnt['backend'] = tags_cnt['backend'] + 1
            if re.search('嵌入式', row.keywords):
                tags_cnt['embedded'] = tags_cnt['embedded'] + 1
            if re.search('自动化', row.keywords):
                tags_cnt['automation'] = tags_cnt['automation'] + 1
            if re.search('模拟', row.keywords):
                tags_cnt['analog'] = tags_cnt['analog'] + 1
            if re.search('求职就业', row.keywords):
                tags_cnt['jobs'] = tags_cnt['jobs'] + 1
            if re.search('管理', row.keywords):
                tags_cnt['management'] = tags_cnt['management'] + 1
            if re.search('软件', row.keywords):
                tags_cnt['software'] = tags_cnt['software'] + 1

            if re.search(kw, row.keywords):
                item = {}
                item['id'] = row.id
                item['title'] = row.title
                item['keywords'] = row.keywords
                item['url'] = row.url
                item['wxname'] = row.wxname
                item['summary'] = row.summary
                article.append(item)
        #num = len(gzh)
        data = {
            'year': y,
            'month': m,
            'article': article,
            'tags_cnt': tags_cnt,
            'wxname': '',
            'gzh_qrcode': '',
            'gzh_intro': ''
        }
    
        return render(request, 'journal_tag.html', data)
        
    
    # toc
    if y == None or m == None:
        t = time.localtime(time.time())
        y = "{:0>4d}".format(t.tm_year)
        m = t.tm_mon

        data = {
            'y': y,
            'm': m
        }
        return render(request, 'journal_toc.html', data)
        
    # detail
    journal = models.journal.objects.filter(year=y).filter(month=m).filter(is_del=0)
    
    data = {}
    article = []
    tags_cnt = {
        'FPGA': 0,
        'frontend': 0,
        'verification': 0,
        'backend': 0,
        'embedded': 0,
        'automation': 0,
        'analog': 0,
        'jobs': 0,
        'management':0,
        'software': 0
    }
    for row in journal:
        # count tags
        if re.search('FPGA', row.keywords):
            tags_cnt['FPGA'] = tags_cnt['FPGA'] + 1
        if re.search('前端', row.keywords):
            tags_cnt['frontend'] = tags_cnt['frontend'] + 1
        if re.search('验证', row.keywords):
            tags_cnt['verification'] = tags_cnt['verification'] + 1
        if re.search('后端', row.keywords):
            tags_cnt['backend'] = tags_cnt['backend'] + 1
        if re.search('嵌入式', row.keywords):
            tags_cnt['embedded'] = tags_cnt['embedded'] + 1
        if re.search('自动化', row.keywords):
            tags_cnt['automation'] = tags_cnt['automation'] + 1
        if re.search('模拟', row.keywords):
            tags_cnt['analog'] = tags_cnt['analog'] + 1
        if re.search('求职就业', row.keywords):
            tags_cnt['jobs'] = tags_cnt['jobs'] + 1
        if re.search('管理', row.keywords):
            tags_cnt['management'] = tags_cnt['management'] + 1
        if re.search('软件', row.keywords):
            tags_cnt['software'] = tags_cnt['software'] + 1
                
        if kw == None or re.search(kw, row.keywords):
            item = {}
            item['id'] = row.id
            item['title'] = row.title
            item['keywords'] = row.keywords
            item['url'] = row.url
            item['wxname'] = row.wxname
            item['summary'] = row.summary
            article.append(item)
    #num = len(gzh)
    data = {
        'year': y,
        'month': m,
        'article': article,
        'tags_cnt': tags_cnt
    }
    
    return render(request, 'journal.html', data)

def journal_gzh(request):
    y = request.GET.get('y')
    m = request.GET.get('m')
    kw = request.GET.get('kw')
    wxname = request.GET.get('wxname')

    # by wxname
    if not wxname == None:
        journal = models.journal.objects.filter(is_del=0)
    
        data = {}
        article = []
        tags_cnt = {
            'FPGA': 0,
            'frontend': 0,
            'verification': 0,
            'backend': 0,
            'embedded': 0,
            'automation': 0,
            'analog': 0,
            'jobs': 0,
            'management':0,
            'software': 0
        }

        for row in journal:
            # count tags
            if re.search('FPGA', row.keywords):
                tags_cnt['FPGA'] = tags_cnt['FPGA'] + 1
            if re.search('前端', row.keywords):
                tags_cnt['frontend'] = tags_cnt['frontend'] + 1
            if re.search('验证', row.keywords):
                tags_cnt['verification'] = tags_cnt['verification'] + 1
            if re.search('后端', row.keywords):
                tags_cnt['backend'] = tags_cnt['backend'] + 1
            if re.search('嵌入式', row.keywords):
                tags_cnt['embedded'] = tags_cnt['embedded'] + 1
            if re.search('自动化', row.keywords):
                tags_cnt['automation'] = tags_cnt['automation'] + 1
            if re.search('模拟', row.keywords):
                tags_cnt['analog'] = tags_cnt['analog'] + 1
            if re.search('求职就业', row.keywords):
                tags_cnt['jobs'] = tags_cnt['jobs'] + 1
            if re.search('管理', row.keywords):
                tags_cnt['management'] = tags_cnt['management'] + 1
            if re.search('软件', row.keywords):
                tags_cnt['software'] = tags_cnt['software'] + 1

            if re.search(wxname, row.wxname):
                item = {}
                item['title'] = row.title
                item['keywords'] = row.keywords
                item['url'] = row.url
                item['wxname'] = row.wxname
                item['summary'] = row.summary
                article.append(item)

        member = models.member.objects.filter(name=wxname)
        gzh_qrcode = ''
        gzh_intro = ''
        for row in member:
            gzh_qrcode = row.qrcode
            gzh_intro = row.intro
        
        data = {
            'year': y,
            'month': m,
            'article': article,
            'tags_cnt': tags_cnt,
            'wxname': wxname,
            'gzh_qrcode': gzh_qrcode,
            'gzh_intro': gzh_intro
        }
    
        return render(request, 'journal_tag.html', data)

    # tag
    if y == None and m == None and not kw == None:
        journal = models.journal.objects.filter(is_del=0)
    
        data = {}
        article = []
        tags_cnt = {
            'FPGA': 0,
            'frontend': 0,
            'verification': 0,
            'backend': 0,
            'embedded': 0,
            'automation': 0,
            'analog': 0,
            'jobs': 0,
            'management':0,
            'software': 0
        }

        for row in journal:
            # count tags
            if re.search('FPGA', row.keywords):
                tags_cnt['FPGA'] = tags_cnt['FPGA'] + 1
            if re.search('前端', row.keywords):
                tags_cnt['frontend'] = tags_cnt['frontend'] + 1
            if re.search('验证', row.keywords):
                tags_cnt['verification'] = tags_cnt['verification'] + 1
            if re.search('后端', row.keywords):
                tags_cnt['backend'] = tags_cnt['backend'] + 1
            if re.search('嵌入式', row.keywords):
                tags_cnt['embedded'] = tags_cnt['embedded'] + 1
            if re.search('自动化', row.keywords):
                tags_cnt['automation'] = tags_cnt['automation'] + 1
            if re.search('模拟', row.keywords):
                tags_cnt['analog'] = tags_cnt['analog'] + 1
            if re.search('求职就业', row.keywords):
                tags_cnt['jobs'] = tags_cnt['jobs'] + 1
            if re.search('管理', row.keywords):
                tags_cnt['management'] = tags_cnt['management'] + 1
            if re.search('软件', row.keywords):
                tags_cnt['software'] = tags_cnt['software'] + 1

            if re.search(kw, row.keywords):
                item = {}
                item['title'] = row.title
                item['keywords'] = row.keywords
                item['url'] = row.url
                item['wxname'] = row.wxname
                item['summary'] = row.summary
                article.append(item)
        #num = len(gzh)
        data = {
            'year': y,
            'month': m,
            'article': article,
            'tags_cnt': tags_cnt,
            'wxname': '',
            'gzh_qrcode': '',
            'gzh_intro': ''
        }
    
        return render(request, 'journal_tag.html', data)
        
    
    # toc
    if y == None or m == None:
        t = time.localtime(time.time())
        y = "{:0>4d}".format(t.tm_year)
        m = t.tm_mon

        data = {
            'y': y,
            'm': m
        }
        
        return render(request, 'journal_toc.html', data)
        
    # detail
    journal = models.journal.objects.filter(year=y).filter(month=m).filter(is_del=0)
    
    data = {}
    article = []
    tags_cnt = {
        'FPGA': 0,
        'frontend': 0,
        'verification': 0,
        'backend': 0,
        'embedded': 0,
        'automation': 0,
        'analog': 0,
        'jobs': 0,
        'management':0,
        'software': 0
    }
    for row in journal:
        # count tags
        if re.search('FPGA', row.keywords):
            tags_cnt['FPGA'] = tags_cnt['FPGA'] + 1
        if re.search('前端', row.keywords):
            tags_cnt['frontend'] = tags_cnt['frontend'] + 1
        if re.search('验证', row.keywords):
            tags_cnt['verification'] = tags_cnt['verification'] + 1
        if re.search('后端', row.keywords):
            tags_cnt['backend'] = tags_cnt['backend'] + 1
        if re.search('嵌入式', row.keywords):
            tags_cnt['embedded'] = tags_cnt['embedded'] + 1
        if re.search('自动化', row.keywords):
            tags_cnt['automation'] = tags_cnt['automation'] + 1
        if re.search('模拟', row.keywords):
            tags_cnt['analog'] = tags_cnt['analog'] + 1
        if re.search('求职就业', row.keywords):
            tags_cnt['jobs'] = tags_cnt['jobs'] + 1
        if re.search('管理', row.keywords):
            tags_cnt['management'] = tags_cnt['management'] + 1
        if re.search('软件', row.keywords):
            tags_cnt['software'] = tags_cnt['software'] + 1
                
        if kw == None or re.search(kw, row.keywords):
            item = {}
            item['title'] = row.title
            item['keywords'] = row.keywords
            item['url'] = row.url
            item['wxname'] = row.wxname
            item['summary'] = row.summary
            article.append(item)
    #num = len(gzh)
    data = {
        'year': y,
        'month': m,
        'article': article,
        'tags_cnt': tags_cnt
    }
    
    return render(request, 'journal_for_gzh.html', data)


def article(request):
    aid = request.GET.get('aid')

    journal = models.journal.objects.filter(is_del=0, id=aid)
    
    data = {}
    article_title = ''
    article_keywords = ''
    article_url = ''
    article_wxname = ''
    article_summary = ''

    for row in journal:
        article_title = row.title
        article_keywords = row.keywords
        article_url = row.url
        article_wxname = row.wxname
        article_summary = row.summary

    member = models.member.objects.filter(name=article_wxname)
    gzh_qrcode = ''
    gzh_intro = ''
    for row in member:
        gzh_qrcode = row.qrcode
        gzh_intro = row.intro
        
    data = {
        'article_title': article_title,
        'article_keywords': article_keywords,
        'article_url': article_url,
        'article_wxname': article_wxname,
        'article_summary': article_summary,
        'gzh_qrcode': gzh_qrcode,
        'gzh_intro': gzh_intro
    }
    
    return render(request, 'article.html', data)


def columns(request):
    data = {}
    data['column_list'] = []
    
    column_list = models.columns.objects.filter(is_del=0, isvip=0).order_by('?')
    for column in column_list:
        t = {}
        t['name'] = column.name
        t['intro'] = column.intro
        t['iscompany'] = column.iscompany
        t['company_name'] = column.company_name
        t['company_fullname'] = column.company_fullname
        t['company_intro'] = column.company_intro
        t['company_weburl'] = column.company_weburl
        t['company_gzh_name'] = column.company_gzh_name
        t['company_gzh_url'] = column.company_gzh_url
        t['logo_url'] = column.logo_url
        
        article_list = models.article.objects.filter(isdel=False, isprivate=False, author=t['name']).order_by('-createdate')
        t['articles'] = []
        cnt = 1
        if article_list.exists():
            for article in article_list:
                tt = {}
                tt['article_id'] = article.id
                tt['article_title'] = article.title
                tt['createdate'] = article.createdate
                
                t['articles'].append(tt)
                
                if cnt == 3:
                    break
                else:
                    cnt = cnt + 1

        data['column_list'].append(t)
    
    return render(request, 'columns.html', data)


def columns_latest(request):
    data = {}
    
    article_list = models.article.objects.filter(isdel=False, isprivate=False).order_by('-createdate')[:20]
    data['articles'] = []

    if article_list.exists():
        for article in article_list:
            tt = {}
            tt['article_id'] = article.id
            tt['article_title'] = article.title
            tt['author'] = article.author
            tt['summary'] = article.summary
            tt['createdate'] = article.createdate
                
            data['articles'].append(tt)
                
    return render(request, 'columns_latest.html', data)

@csrf_exempt
def get_rand_4column(request):
    data = {}
    
    article_list = models.article.objects.filter(isdel=False, isprivate=False).order_by('?')[:4]
    data['articles'] = []

    if article_list.exists():
        for article in article_list:
            tt = {}
            tt['article_id'] = article.id
            tt['article_title'] = article.title
            tt['author'] = article.author
            tt['summary'] = article.summary
            tt['createdate'] = article.createdate
                
            data['articles'].append(tt)
                
    return JsonResponse(data, safe=False)


def columns_signup(request):
    data = {}
    return render(request, 'columns_signup.html', data)


def columns_login(request):
    data = {}
    return render(request, 'columns_login.html', data)


@csrf_exempt
def columns_signup_handle(request):
    data = {}

    column_name = request.POST.get('column_name')
    if len(column_name) > 60:
        data['msg'] = '专栏名称太长了'
        return JsonResponse(data, safe=False)

    column_intro = request.POST.get('column_intro')
    if len(column_intro) > 60:
        data['msg'] = '专栏介绍太长了'
        return JsonResponse(data, safe=False)
    
    count = models.columns.objects.filter(name=column_name).count()
    if count != 0:
        data['msg'] = '专栏名称已存在'
        return JsonResponse(data, safe=False)

    column_pswd = request.POST.get('column_pswd')
    if len(column_pswd) < 6:
        data['msg'] = '密码太短了'
        return JsonResponse(data, safe=False)
        
    models.columns.objects.create(
        name = column_name,
        intro = column_intro,
        pswd = column_pswd,
        logo_url = 'image/column_logo.png'
    )

    # write session
    request.session['column_name'] = column_name
    request.session['logged'] = True
    request.session.set_expiry(86400)
    
    data['msg'] = '注册成功'
    return JsonResponse(data, safe=False)


@csrf_exempt
def columns_login_status(request):
    data = {}
    if 'logged' in request.session and request.session['logged'] == True and request.session['column_name'] == request.POST.get('column_name'):
        data['msg'] = 'pass'
    else:
        data['msg'] = 'fail'
    return JsonResponse(data, safe=False)


@csrf_exempt
def columns_login_check(request):
    column_name = request.POST.get('column_name')
    column_pswd = request.POST.get('column_pswd')

    temp = models.columns.objects.filter(name=column_name)
    
    data = {}

    if temp.exists() and temp[0].pswd == column_pswd:
        # write session
        request.session['column_name'] = column_name
        request.session['logged'] = True
        request.session.set_expiry(86400)
        
        data = {
            'msg': 'pass'
        }
    else:
        data = {
            'msg': 'fail'
        }
        
    return JsonResponse(data, safe=False)


@csrf_exempt
def columns_login_out(request):
    # delete session
    request.session['logged'] = False
    request.session.flush()

    data = {
        'msg': 'pass'
    }

    return JsonResponse(data, safe=False)


def article_column(request):
    if request.GET.get('id'):
        """show one column article by id"""
        temp_list = models.article.objects.filter(isdel=False, id=request.GET.get('id'))
        
        data = {}
        if temp_list == None or len(temp_list) == 0:
            data['id'] = '0'
            data['author'] = ''
            data['title'] = ''
            data['summary'] = ''
            data['readcnt'] = ''
            data['createdate'] = ''
            data['article_html'] = ''
        else:
            temp = temp_list[0]
            data['id'] = temp.id
            data['author'] = temp.author
            data['title'] = temp.title
            data['summary'] = temp.summary
            data['readcnt'] = temp.readcnt + 1 + temp.gzh_readcnt
            data['createdate'] = temp.createdate

            html_base64_str = temp.html

            html_bytes = base64.b64decode(html_base64_str.encode('utf-8'))
            html_str = html_bytes.decode('utf-8')
            data['article_html'] = mark_safe(html_str)
            
            temp.readcnt = temp.readcnt + 1 
            temp.save()
        
        return render(request, 'column_detail.html', data)
    
    elif request.GET.get('s'):
        """show one column article by share url"""
        id_b64str = request.GET.get('s')
        id_byte = base64.b64decode(id_b64str.encode('utf-8'))
        id_str = id_byte.decode('utf-8')
        id_int = int(id_str.split('_')[1])
        
        temp_list = models.article.objects.filter(isdel=False, id=id_int)
        
        data = {}
        if temp_list == None or len(temp_list) == 0:
            data['id'] = '0'
            data['author'] = ''
            data['title'] = ''
            data['summary'] = ''
            data['readcnt'] = ''
            data['createdate'] = ''
            data['article_html'] = ''
        else:
            temp = temp_list[0]
            data['id'] = temp.id
            data['author'] = temp.author
            data['title'] = temp.title
            data['summary'] = temp.summary
            data['readcnt'] = temp.readcnt + 1 + temp.gzh_readcnt
            data['createdate'] = temp.createdate

            html_base64_str = temp.html

            html_bytes = base64.b64decode(html_base64_str.encode('utf-8'))
            html_str = html_bytes.decode('utf-8')
            data['article_html'] = mark_safe(html_str)
            
            temp.readcnt = temp.readcnt + 1
            temp.save()
        
        return render(request, 'column_detail.html', data)
    
    elif request.GET.get('name'):
        """show all articles of `name`"""
        column = models.columns.objects.get(name=request.GET.get('name'))
        
        temp = models.article.objects.filter(isdel=False, author=request.GET.get('name')).order_by('-createdate')

        data = {}
        data['author'] = request.GET.get('name')

        data['logo_url'] = column.logo_url
        data['intro'] = column.intro
        data['iscompany'] = column.iscompany
        data['company_name'] = column.company_name
        data['company_fullname'] = column.company_fullname
        data['company_intro'] = column.company_intro
        data['company_weburl'] = column.company_weburl
        data['company_gzh_name'] = column.company_gzh_name
        data['company_gzh_url'] = column.company_gzh_url

        if 'logged' in request.session and request.session['logged'] == True and request.session['column_name'] == request.GET.get('name'):
            data['islogged'] = True
        else:
            data['islogged'] = False
        
        article_list = []
        data['article_list'] = article_list

        for res in temp:
            t = {}
            t['id'] = res.id
            t['author'] = res.author
            t['title'] = res.title
            t['summary'] = res.summary
            t['createdate'] = res.createdate
            t['readcnt'] = res.readcnt + res.gzh_readcnt
            t['isprivate'] = res.isprivate
            article_list.append(t)

        #get collects of author
        temp = models.collects.objects.filter(author=request.GET.get('name'))
        collects = []
        data['collects'] = collects

        for res in temp:
            t = {}
            t['id'] = res.id
            t['name'] = res.name
            t['author'] = res.author
            t['intro'] = res.intro
            t['articlelist'] = res.articlelist
            if t['articlelist']:
                t['total'] = len(t['articlelist'].split(','))
            else:
                t['total'] = 0
            collects.append(t)
            
        return render(request, 'column_home.html', data)
    

def column_home(request):
    """show all articles of `name`"""
    column = models.columns.objects.get(name=request.GET.get('name'))
        
    temp = models.article.objects.filter(isdel=False, author=request.GET.get('name')).order_by('-createdate')

    data = {}
    data['author'] = request.GET.get('name')

    data['logo_url'] = column.logo_url
    data['intro'] = column.intro
    data['iscompany'] = column.iscompany
    data['company_name'] = column.company_name
    data['company_fullname'] = column.company_fullname
    data['company_intro'] = column.company_intro
    data['company_weburl'] = column.company_weburl
    data['company_gzh_name'] = column.company_gzh_name
    data['company_gzh_url'] = column.company_gzh_url

    if 'logged' in request.session and request.session['logged'] == True and request.session['column_name'] == request.GET.get('name'):
        data['islogged'] = True
    else:
        data['islogged'] = False
        
    article_list = []
    data['article_list'] = article_list

    for res in temp:
        t = {}
        t['id'] = res.id
        t['author'] = res.author
        t['title'] = res.title
        t['summary'] = res.summary
        t['createdate'] = res.createdate
        t['readcnt'] = res.readcnt + res.gzh_readcnt
        t['isprivate'] = res.isprivate
        article_list.append(t)

    #get collects of author
    temp = models.collects.objects.filter(author=request.GET.get('name'))
    collects = []
    data['collects'] = collects

    for res in temp:
        t = {}
        t['id'] = res.id
        t['name'] = res.name
        t['author'] = res.author
        t['intro'] = res.intro
        t['articlelist'] = res.articlelist
        if t['articlelist']:
            t['total'] = len(t['articlelist'].split(','))
        else:
            t['total'] = 0
        collects.append(t)
            
    return render(request, 'column_home.html', data)


def column_home_edit(request):
    """show all articles of `name`"""
    column = models.columns.objects.get(name=request.GET.get('name'))
        
    temp = models.article.objects.filter(isdel=False, author=request.GET.get('name')).order_by('-createdate')

    data = {}
    data['author'] = request.GET.get('name')

    data['logo_url'] = column.logo_url
    data['intro'] = column.intro
    data['iscompany'] = column.iscompany
    data['company_name'] = column.company_name
    data['company_fullname'] = column.company_fullname
    data['company_intro'] = column.company_intro
    data['company_weburl'] = column.company_weburl
    data['company_gzh_name'] = column.company_gzh_name
    data['company_gzh_url'] = column.company_gzh_url

    if 'logged' in request.session and request.session['logged'] == True and request.session['column_name'] == request.GET.get('name'):
        data['islogged'] = True
    else:
        data['islogged'] = False
        
    article_list = []
    data['article_list'] = article_list

    for res in temp:
        t = {}
        t['id'] = res.id
        t['author'] = res.author
        t['title'] = res.title
        t['summary'] = res.summary
        t['createdate'] = res.createdate
        t['readcnt'] = res.readcnt + res.gzh_readcnt
        t['isprivate'] = res.isprivate
        article_list.append(t)

    #get collects of author
    temp = models.collects.objects.filter(author=request.GET.get('name'))
    collects = []
    data['collects'] = collects

    for res in temp:
        t = {}
        t['id'] = res.id
        t['name'] = res.name
        t['author'] = res.author
        t['intro'] = res.intro
        t['articlelist'] = res.articlelist
        if t['articlelist']:
            t['total'] = len(t['articlelist'].split(','))
        else:
            t['total'] = 0
        collects.append(t)
            
    return render(request, 'column_home_edit.html', data)

    
@csrf_exempt    
def columns_info_update(request):
    #log = open(settings.BASE_DIR + '/debug.log', 'w')
    
    name = request.POST.get('author')
    intro = request.POST.get('intro')
    logo_url = request.POST.get('logo_url')
    #logo_url = re.sub(r'.*static/', '', logo_url)

    #log.write("debug: name = " + name + "\n")
    #log.write("debug: intro = " + intro + "\n")
    #log.write("debug: logo_url = " + logo_url + "\n")
        
    temp = models.columns.objects.get(name=name)
    #log.write("debug: db.intro = " + temp.intro + "\n")
    #log.close()
    temp.intro = intro
    temp.logo_url = logo_url
    temp.save()
    
    data = {'msg': "修改成功"}
    return JsonResponse(data, safe=False)
    
def collect(request):
    if request.GET.get('id'):
        """show one collection by id"""
        temp_list = models.collects.objects.filter(id=request.GET.get('id'))
        
        data = {}
        if temp_list == None or len(temp_list) == 0:
            data['id'] = '0'
            data['name'] = ''
            data['author'] = ''
            data['intro'] = ''
            data['articlelist'] = ''
        else:
            temp = temp_list[0]
            data['id'] = temp.id
            data['name'] = temp.name
            data['author'] = temp.author
            data['intro'] = temp.intro
            data['articlelist'] = temp.articlelist
            
            articles = []
            data['articles'] = articles
            if data['articlelist']:
                articlelist = data['articlelist'].split(',')
                for articleid in articlelist:
                    article = models.article.objects.filter(id=int(articleid))
                    if len(article) != 0:
                        article0 = article[0]
                        t = {}
                        t['id'] = article0.id
                        t['title'] = article0.title
                        t['author'] = article0.author
                        t['summary'] = article0.summary
                        t['createdate'] = article0.modifydate
                        t['readcnt'] = article0.readcnt
                        t['likecnt'] = article0.likecnt
                        t['isprivate'] = article0.isprivate
                        articles.append(t)
                        
        if 'logged' in request.session and request.session['logged'] == True and request.session['column_name'] == data['author']:
            data['islogged'] = True
        else:
            data['islogged'] = False
        
        return render(request, 'collect.html', data)

    
@csrf_exempt
def collect_create(request):
    temp = models.collects.objects.create(
        name = request.POST.get('name'),
        author = request.POST.get('author'),
        intro = request.POST.get('intro')
    )

    data = {'msg': '创建成功'}
    return JsonResponse(data, safe=False)


def collect_edit(request):
    if request.GET.get('id'):
        """show one collection by id"""
        temp_list = models.collects.objects.filter(id=request.GET.get('id'))
        
        data = {}
        if temp_list == None or len(temp_list) == 0:
            data['id'] = '0'
            data['name'] = ''
            data['author'] = ''
            data['intro'] = ''
            data['articlelist'] = ''
        else:
            temp = temp_list[0]
            data['id'] = temp.id
            data['name'] = temp.name
            data['author'] = temp.author
            data['intro'] = temp.intro
            data['articlelist'] = temp.articlelist
            
            articles = []
            data['articles'] = articles
            if data['articlelist']:
                articlelist = data['articlelist'].split(',')
                for articleid in articlelist:
                    article = models.article.objects.filter(id=int(articleid))
                    if len(article) != 0:
                        article0 = article[0]
                        t = {}
                        t['id'] = article0.id
                        t['title'] = article0.title
                        t['author'] = article0.author
                        t['summary'] = article0.summary
                        t['createdate'] = article0.modifydate
                        t['readcnt'] = article0.readcnt
                        t['likecnt'] = article0.likecnt
                        t['isprivate'] = article0.isprivate
                        articles.append(t)
                        
        if 'logged' in request.session and request.session['logged'] == True and request.session['column_name'] == data['author']:
            data['islogged'] = True
        else:
            data['islogged'] = False
                        
        return render(request, 'collect_edit.html', data)

    
@csrf_exempt
def collect_append_id(request):
    cid = request.POST.get('cid')
    aid = request.POST.get('aid')

    temp = models.collects.objects.get(id=cid)

    data = {}
    if temp.articlelist == '':
        temp.articlelist = aid
        data = {'msg': '成功添加第一篇合集文章'}
    else:
        temp.articlelist += ',' + aid
        data = {'msg': '添加成功'}
    temp.save()
    
    return JsonResponse(data, safe=False)


@csrf_exempt
def collect_remove_id(request):
    cid = request.POST.get('cid')
    aid = request.POST.get('aid')

    temp = models.collects.objects.get(id=cid)
    articlelist = temp.articlelist
    
    articles = articlelist.split(',')
    articles_new = []
    for article_id in articles:
        if article_id != aid:
            articles_new.append(article_id)
            
    temp.articlelist = ','.join(articles_new)
    temp.save()
    
    data = {
        'msg': '移出成功'
    }
    return JsonResponse(data, safe=False)

    
@csrf_exempt
def column_article_delete(request):
    id = request.POST.get('id')
    temp = models.article.objects.get(id=id)
    temp.isdel = True
    temp.save()
        
    data = {
        'msg': 'delete successfully'
    }
    
    return JsonResponse(data, safe=False)


@csrf_exempt
def column_readcnt(request):
    id = request.GET.get('id', '50')
    temp_list = models.article.objects.filter(isdel=False, id=id)

    data = {}
    if temp_list == None or len(temp_list) == 0:
        data['id'] = 0
        data['author'] = ''
        data['title'] = ''
        data['readcnt'] = 0
        data['gzh_read_cnt'] = 0
        data['likecnt'] = 0
    else:
        temp = temp_list[0]
        data['id'] = temp.id
        data['author'] = temp.author
        data['title'] = temp.title
        data['readcnt'] = temp.readcnt
        data['gzh_readcnt'] = temp.gzh_readcnt
        data['likecnt'] = temp.likecnt

    return render(request, 'column_readcnt.html', data)
    
    
@csrf_exempt
def column_readcnt_update(request):
    id = request.POST.get('id')
    temp_list = models.article.objects.filter(isdel=False, id=id)
    temp = temp_list[0]
    
    temp.readcnt = request.POST.get('readcnt')
    temp.gzh_readcnt = request.POST.get('gzh_readcnt')
    temp.likecnt = request.POST.get('likecnt')
    temp.save()

    data = {}
    data['msg'] = "更新成功";

    return JsonResponse(data, safe=False)


@csrf_exempt
def article_publish(request):
    t = time.localtime(time.time())
    
    dt = "{:0>4d}-{:0>2d}-{:0>2d} {:0>2d}:{:0>2d}:{:0>2d}".format(
        t.tm_year,
        t.tm_mon,
        t.tm_mday,
        t.tm_hour,
        t.tm_min,
        t.tm_sec
        )

    id = request.POST.get('id')
    if id == '0':
        temp = models.article.objects.create(
            author = request.POST.get('author'),
            title = request.POST.get('title'),
            summary = request.POST.get('summary'),
            md = request.POST.get('md_base64'),
            html = request.POST.get('html_base64'),
            createdate = dt,
            isprivate = request.POST.get('isprivate'),
            modifydate = dt,
        )
        id = temp.id
    else:
        temp = models.article.objects.get(id=id)
        temp.author = request.POST.get('author')
        temp.title = request.POST.get('title')
        temp.summary = request.POST.get('summary')
        temp.md = request.POST.get('md_base64')
        temp.html = request.POST.get('html_base64')
        temp.isprivate = request.POST.get('isprivate')
        temp.modifydate = dt
        temp.save()
        
    data = {
        'msg': 'publish successfully',
        'id': id
    }
    
    return JsonResponse(data, safe=False)

def selfpost(request): #load
    #import time
    t = time.localtime(time.time())
    y = "{:0>4d}".format(t.tm_year)
    m = "{:0>2d}".format(t.tm_mon)
    #y = "2020"
    #m = "12"

    y1 = request.GET.get('y')
    m1 = request.GET.get('m')
    if y1:
        y = y1
    if m1:
        m = m1
    
    # detail
    journal = models.journal.objects.filter(year=y).filter(month=m).filter(is_del=0)
    
    data = {}
    article = []
    for row in journal:
        item = {}
        item['id'] = row.id
        item['title'] = row.title
        item['keywords'] = row.keywords
        item['url'] = row.url
        item['wxname'] = row.wxname
        item['summary'] = row.summary
        article.append(item)
    #num = len(gzh)
    data = {
        'year': y,
        'month': m,
        'article': article
    }
    
    return render(request, 'selfpost.html', data)

def search(request): # search by keywords
    kw = request.GET.get('kw')
    if not kw == None and not kw == "":

        data = {}
        article = []
        found = 0
        
        def highlight(s):
            return '<span style="color:red">{}</span>'.format(s.group(0))

        # search in journal
        journal = models.journal.objects.filter(is_del=0).order_by('-id')

        for row in journal:
            m = 0
            item = {}
            item['title'] = '【期刊】' + row.title
            item['keywords'] = row.keywords
            item['url'] = row.url
            item['wxname'] = row.wxname
            item['summary'] = row.summary
            item['source'] = "iccircle"
            
            if re.search(kw, row.title, re.I):
                m = 1
                found = 1
                result = re.sub(kw, highlight, row.title, 0, re.I)
                item['title'] = '【期刊】' + result

            if re.search(kw, row.keywords, re.I):
                m = 1
                result = re.sub(kw, highlight, row.keywords, 0, re.I)
                item['keywords'] = result
                found = 1
                
            if row.summary and re.search(kw, row.summary, re.I):
                m = 1
                found = 1
                result = re.sub(kw, highlight, row.summary, 0, re.I)
                item['summary'] = result

            if m == 1:
                article.append(item)

        # search in columns
        column = models.article.objects.filter(isprivate=False, isdel=False).order_by('-id')
        
        for row in column:
            m = 0
            item = {}
            item['title'] = '【专栏】' + row.title
            item['keywords'] = ''
            item['url'] = 'https://iccircle.com/column?id={}'.format(row.id)
            item['wxname'] = row.author
            item['summary'] = row.summary
            item['source'] = "iccircle"
            
            if re.search(kw, row.title, re.I):
                m = 1
                found = 1
                result = re.sub(kw, highlight, row.title, 0, re.I)
                item['title'] = '【专栏】' + result

            if re.search(kw, row.summary, re.I):
                m = 1
                result = re.sub(kw, highlight, row.summary, 0, re.I)
                item['summary'] = result
                found = 1
                
            if m == 1:
                article.append(item)

        import random
        random.shuffle(article)
                
        data = {
            'found': found,
            'kw': kw,
            'article': article
        }
    else:
        data = {
            'found': 0,
            'kw': '',
            'article': {}
        }
        
    return render(request, 'search.html', data)

@csrf_exempt
def selfpost_add_update(request): #add or update

    #data = {"msg": "success"}
    #return JsonResponse(data, safe=False)
    
    #import time
    t = time.localtime(time.time())
    y1 = "{:0>4d}".format(t.tm_year)
    m1 = "{:0>2d}".format(t.tm_mon)
    #y = "2020"
    #m = "11"

    y = request.POST.get('year', y1)
    m = request.POST.get('month', m1)
    
    #d = "{:0>4d}-{:0>2d}-{:0>2d}".format(t.tm_year, t.tm_mon, t.tm_mday)
    d = "{}-{}-{:0>2d}".format(y, m, t.tm_mday)
    #d = "2020-11-14"
    
    # add
    if request.POST.get('id') == '':
        models.journal.objects.create(
            title = request.POST.get('title'),
            keywords = request.POST.get('keywords'),
            url = request.POST.get('url'),
            wxname = request.POST.get('wxname'),
            year = y,
            month = m,
            adddate = d,
            summary = request.POST.get('summary'),
            is_del = 0
        )

        data = {'msg': "add successfully"}
        
    # update
    else:
        post_id = request.POST.get('id')
        temp = models.journal.objects.get(id=post_id)
        
        temp.title = request.POST.get('title')
        temp.keywords = request.POST.get('keywords')
        temp.url = request.POST.get('url')
        temp.wxname = request.POST.get('wxname')
        temp.summary = request.POST.get('summary')
        
        temp.save()

        data = {'msg': "update successfully"}

    return JsonResponse(data, safe=False)

@csrf_exempt
def selfpost_delete(request): #del
    post_id = request.POST.get('id')
    temp = models.journal.objects.get(id=post_id)
        
    temp.is_del = 1
    
    temp.save()

    data = {'msg': "delete successfully"}

    return JsonResponse(data, safe=False)

@csrf_exempt
def selfpost_get_by_id(request): #get one record by id
    post_id = request.POST.get('id')
    records = models.journal.objects.filter(id=post_id)

    data = {}
    for row in records:
        data['id'] = row.id
        data['title'] = row.title
        data['keywords'] = row.keywords
        data['url'] = row.url
        data['wxname'] = row.wxname
        data['summary'] = row.summary

    return JsonResponse(data, safe=False)

# show article in selfpost
def journal_detail(request):
    post_id = request.GET.get('id')
    records = models.journal.objects.filter(id=post_id)

    data = {}
    if records.exists():
        data['id'] = records[0].id
        data['title'] = records[0].title
        data['keywords'] = records[0].keywords
        data['url'] = records[0].url
        data['wxname'] = records[0].wxname
        data['summary'] = records[0].summary
        
    return render(request, 'journal_detail.html', data)

def member_update(request):

    data = {}
    return render(request, 'member_update.html', data)

def member_info_update(request):

    data = {}
    return render(request, 'member_info_update.html', data)

@csrf_exempt
def search_member_id_by_name(request):
    gzh_name = request.GET.get('gzh_name')
    
    member = models.member.objects.filter(name=gzh_name)
    
    data = {}

    if member.exists():
        data = {
            'empty': 'no',
            'gzh_id': member[0].mid,
            'gzh_name': member[0].name,
            'tags': member[0].tags,
            'hot': member[0].hot
        }
    else:
        data = {
            'empty': 'yes'
        }
        
    return JsonResponse(data, safe=False)

@csrf_exempt
def load_gzh_info(request):
    gzh_mid = request.GET.get('mid')

    member = models.member.objects.filter(mid=gzh_mid)

    data = {}

    if member.exists():
        data = {
            'empty': 'no',
            'qrcode': member[0].qrcode,
            'intro': member[0].intro,
            'tags': member[0].tags,
            'hot': member[0].hot
        }
    else:
        data = {
            'empty': 'yes'
        }

    return JsonResponse(data, safe=False)

@csrf_exempt
def update_gzh_info(request):
    gzh_mid = request.POST.get('mid')
    temp = models.member.objects.get(mid=gzh_mid)

    temp.name = request.POST.get('name')
    temp.intro = request.POST.get('intro')
    temp.qrcode = request.POST.get('qrcode')
    temp.tags = request.POST.get('tags')
    temp.hot = request.POST.get('hot')
    temp.save()
    
    data = {'msg': "update successfully"}

    return JsonResponse(data, safe=False)

@csrf_exempt
def author_info_add_update(request):
    # add
    if request.POST.get('id') == '':
        models.author.objects.create(
            author_name = request.POST.get('author_name'),
            intro = request.POST.get('author_intro'),
            mid = request.POST.get('mid'),
	    sph_name = request.POST.get('sph_name'),
	    zsxq_name = request.POST.get('zsxq_name'),
	    csdn_name = request.POST.get('csdn_name'),
	    csdn_url = request.POST.get('csdn_url'),
	    bili_name = request.POST.get('bili_name'),
	    bili_url = request.POST.get('bili_url'),
	    blog2_name = request.POST.get('blog2_name'),
	    blog2_url = request.POST.get('blog2_url'),
	    toutiao_name = request.POST.get('toutiao_name'),
	    toutiao_url = request.POST.get('toutiao_url'),
	    zhihu_name = request.POST.get('zhihu_name'),
	    zhihu_url = request.POST.get('zhihu_url'),
	    xhs_name = request.POST.get('xhs_name'),
	    xhs_url = request.POST.get('xhs_url'),
	    web_name = request.POST.get('web_name'),
	    web_url = request.POST.get('web_url'),
	    other_url1 = request.POST.get('other_url1'),
	    other_url2 = request.POST.get('other_url2')
        )

        data = {'msg': "add successfully"}
        
    # update
    else:
        author_id = request.POST.get('id')
        temp = models.author.objects.get(author_id=author_id)
        
        temp.author_name = request.POST.get('author_name')
        temp.intro = request.POST.get('author_intro')
        temp.mid = request.POST.get('mid')
        temp.sph_name = request.POST.get('sph_name')
        temp.zsxq_name = request.POST.get('zsxq_name')
        temp.csdn_name = request.POST.get('csdn_name')
        temp.csdn_url = request.POST.get('csdn_url')
        temp.bili_name = request.POST.get('bili_name')
        temp.bili_url = request.POST.get('bili_url')
        temp.blog2_name = request.POST.get('blog2_name')
        temp.blog2_url = request.POST.get('blog2_url')
        temp.toutiao_name = request.POST.get('toutiao_name')
        temp.toutiao_url = request.POST.get('toutiao_url')
        temp.zhihu_name = request.POST.get('zhihu_name')
        temp.zhihu_url = request.POST.get('zhihu_url')
        temp.xhs_name = request.POST.get('xhs_name')
        temp.xhs_url = request.POST.get('xhs_url')
        temp.web_name = request.POST.get('web_name')
        temp.web_url = request.POST.get('web_url')
        temp.other_url1 = request.POST.get('other_url1')
        temp.other_url2 = request.POST.get('other_url2')

        temp.save()

        data = {'msg': "update successfully"}

    return JsonResponse(data, safe=False)

@csrf_exempt
def load_author_info(request):
    mid = request.GET.get('mid')

    author = models.author.objects.filter(mid=mid)
    
    data = {}
    if author.exists():
        data['empty'] = "no"
        data['author_id'] = author[0].author_id
        data['author_name'] = author[0].author_name
        data['intro'] = author[0].intro
        data['sph_name'] = author[0].sph_name
        data['sph_qrcode'] = author[0].sph_qrcode
        data['zsxq_name'] = author[0].zsxq_name
        data['zsxq_qrcode'] = author[0].zsxq_qrcode
        data['csdn_name'] = author[0].csdn_name
        data['csdn_url'] = author[0].csdn_url
        data['bili_name'] = author[0].bili_name
        data['bili_url'] = author[0].bili_url
        data['blog2_name'] = author[0].blog2_name
        data['blog2_url'] = author[0].blog2_url
        data['toutiao_name'] = author[0].toutiao_name
        data['toutiao_url'] = author[0].toutiao_url
        data['zhihu_name'] = author[0].zhihu_name
        data['zhihu_url'] = author[0].zhihu_url
        data['xhs_name'] = author[0].xhs_name
        data['xhs_url'] = author[0].xhs_url
        data['web_name'] = author[0].web_name
        data['web_url'] = author[0].web_url
        data['other_url1'] = author[0].other_url1
        data['other_url2'] = author[0].other_url2
    else:
        data['empty'] = "yes"

    return JsonResponse(data, safe=False)


def gzh_feed_v2(request):
    t = time.localtime(time.time())
    now = '{:0>4d}-{:0>2d}-{:0>2d} {:0>2d}:{:0>2d}:{:0>2d}'.format(
        t.tm_year, t.tm_mon, t.tm_mday,
        t.tm_hour, t.tm_min, t.tm_sec
    )
        
    data = {}
    data['now'] = now

    if request.GET.get('column'):
        # author's column feed
        
        author = request.GET.get('column')
        data['author'] = author
        
        article_list = []
        articles = models.article.objects.filter(isdel=0, isprivate=0, author=author).order_by('-modifydate')[:30]
    
        for row in articles:
            article = {}
            article['title'] = row.title
            article['url'] = 'https://iccircle.com/column?id={}'.format(row.id)
            article['summary'] = row.summary
            article['author'] = row.author
            article['create_dt'] = row.modifydate
        
            article_list.append(article)

            data['article_list'] = article_list
        
        return render(request, 'feed_column.html', data, content_type='application/xml;charset=utf-8')
        
    else:
        # journal feed
        
        journal_list = []
        journal = models.journal.objects.filter(is_del=0).order_by('-id')[:30]
    
        for row in journal:
            article = {}
            article['title'] = row.title
            article['url'] = row.url
            article['summary'] = '【关键词】{}。【摘要】{}'.format(row.keywords, row.summary)
            article['author'] = row.wxname
        
            t = time.mktime((row.adddate.year, row.adddate.month, row.adddate.day, 0, 0, 0, -1, -1, -1))
            t1 = time.localtime(t)
            t2 = time.strftime('%a, %d %b %Y %H:%M:%S', time.localtime(t))
            article['create_dt'] = t2
        
            journal_list.append(article)

            data['journal_list'] = journal_list
        
        return render(request, 'feed.html', data, content_type='application/xml;charset=utf-8')

    
def image(request):
    user = request.GET.get('user')
    data = {}
    img = []
    num = 0
    
    if user:
        image_by_user = models.img.objects.filter(img_create_by=user).order_by('-img_create_on')

        for row in image_by_user:
            item = {}
            item['img_id'] = row.img_id
            item['img_name'] = row.img_name
            item['img_create_on'] = row.img_create_on
            img.append(item)
            num = len(img)

    data = {
        'img': img,
        'num': num
    }
        
    return render(request, 'image.html', data)
    
    
def image_upload(request):
    data = {}
    
    return render(request, 'image_upload.html', data)

def image_upload_handle(request):
    image = request.FILES.get('image')
    user = request.POST.get('user')

    #import time
    t = time.localtime(time.time())
    
    m = re.search(r'\.(\w+)$', image.name)
    suffix = m.group(1)
    
    image_name = "img{:0>4d}{:0>2d}{:0>2d}{:0>2d}{:0>2d}{:0>2d}.{}".format(
        t.tm_year,
        t.tm_mon,
        t.tm_mday,
        t.tm_hour,
        t.tm_min,
        t.tm_sec,
        suffix)
    
    # save image
    save_path = '{}/{}/{}'.format(settings.BASE_DIR, 'static/upload', image_name)
    with open(save_path, 'wb') as f:
        for content in image.chunks():
            f.write(content)

    # save in database
    img_name = '{}/{}'.format('upload', image_name)
    models.img.objects.create(
        img_name = img_name,
        img_create_by = user,
        img_valid_hours = 0
    )
    
    # return result
    image_by_user = models.img.objects.filter(img_create_by=user).order_by('-img_create_on')

    data = {}
    img = []
    for row in image_by_user:
        item = {}
        item['img_id'] = row.img_id
        item['img_name'] = row.img_name
        item['img_create_on'] = row.img_create_on
        img.append(item)
    num = len(img)
    data = {
        'img': img,
        'num': num
    }
    
    return render(request, 'image.html', data)

@csrf_exempt
def image_upload_geturl_handle(request):
    image = request.FILES.get('image')
    user = 'default'

    #import time
    t = time.localtime(time.time())
    
    m = re.search(r'\.(\w+)$', image.name)
    suffix = m.group(1)
    
    image_name = "img{:0>4d}{:0>2d}{:0>2d}{:0>2d}{:0>2d}{:0>2d}.{}".format(
        t.tm_year,
        t.tm_mon,
        t.tm_mday,
        t.tm_hour,
        t.tm_min,
        t.tm_sec,
        suffix)
    
    # save image
    save_path = '{}/{}/{}'.format(settings.BASE_DIR, 'static/upload', image_name)
    with open(save_path, 'wb') as f:
        for content in image.chunks():
            f.write(content)
 
    # save in database
    img_name = '{}/{}'.format('upload', image_name)
    models.img.objects.create(
        img_name = img_name,
        img_create_by = user,
        img_valid_hours = 0
    )
    
    # return result
    data = {
        'imgurl': 'https://iccircle.com/static/upload/' + image_name
    }
 
    return JsonResponse(data, safe=False)


def txtimage(request):
    data = {}

    return render(request, 'txtimage.html', data)
    

def eda(request):
    '''
    the main page of eda

    '''

    shareid = request.GET.get('shareid', '')
    if shareid != '':
        
        records = models.edashare.objects.filter(tmpdir=shareid)

        for row in records:
            v_b64 = row.code
            author = row.author
            title = row.title
            description = row.description
            lang = row.lang
            break

    else:
        v_b64 = ''
        author = ''
        title = ''
        description = ''
        lang = ''
    
    data = {
        "shareid": shareid,
        "v_b64": v_b64,
        "author": author,
        "title": title,
        "description": description,
        "lang": lang
    }
    
    return render(request, 'eda.html', data)


def run_timeout(cmd, t=60, stdout=subprocess.STDOUT, stderr=subprocess.STDOUT):
    '''
    run eda cmd in t seconds
    '''
    #global p
    
    flag = 0

    p = subprocess.Popen(cmd,
                         shell=True,
                         stdout=stdout,
                         stderr=stderr
                         )
    #print('Process start...')
    #for i in range(t):
    #    time.sleep(1)
    #    if p.poll() != None:
    #        stdout.write('Process done!\n')
    #        flag = 1
    #        break
    #if flag == 0:
    #    p.kill()
    #    stdout.write('Timeout, kill process!\n')
    

@csrf_exempt
def eda_save_simulate(request):
    '''
    this is the flow script
    '''
    
    # get parammeters from request.POST
    lang = request.POST.get('lang')
    tmp_dir = request.POST.get('tmp_dir')
    file1_base64_str = request.POST.get('file1_base64')
    input1_base64_str = request.POST.get('input1_base64')

    file1_bytes = base64.b64decode(file1_base64_str.encode('utf-8'))
    file1_str = file1_bytes.decode('utf-8')

    input1_bytes = base64.b64decode(input1_base64_str.encode('utf-8'))
    input1_str = input1_bytes.decode('utf-8')

    # create sim dir and save verilog file to it
    if not os.path.exists("/tmp/{}".format(tmp_dir)):
        os.makedirs("/tmp/{}".format(tmp_dir))
        
    if lang == 'verilog':
        f = open("/tmp/{}/file1.v".format(tmp_dir), 'w')
    elif lang == 'systemverilog':
        f = open("/tmp/{}/file1.sv".format(tmp_dir), 'w')
    elif lang == 'python':
        f = open("/tmp/{}/file1.py".format(tmp_dir), 'w')
    elif lang == 'cpp':
        f = open("/tmp/{}/file1.cpp".format(tmp_dir), 'w')
    elif lang == 'c':
        f = open("/tmp/{}/file1.c".format(tmp_dir), 'w')
    elif lang == 'perl':
        f = open("/tmp/{}/file1.pl".format(tmp_dir), 'w')
    elif lang == 'tcl':
        f = open("/tmp/{}/file1.tcl".format(tmp_dir), 'w')
    elif lang == 'go':
        f = open("/tmp/{}/file1.go".format(tmp_dir), 'w')
    f.write(file1_str)
    f.close()

    input1 = open("/tmp/{}/input1.txt".format(tmp_dir), 'w')
    input1.write(input1_str)
    input1.close()
    
    # run simulation
    if lang == 'verilog':
        cmd = 'cd /tmp/{} && iverilog -g2012 -o sim.exe file1.v && ./sim.exe'.format(tmp_dir)
    elif lang == 'systemverilog':
        cmd = 'cd /tmp/{} && galaxsim -R -sverilog file1.sv'.format(tmp_dir)
    elif lang == 'python':
        cmd = 'cd /tmp/{} && python3 file1.py < input1.txt'.format(tmp_dir)
    elif lang == 'cpp':
        cmd = 'cd /tmp/{} && g++ -g -Wall -o out file1.cpp && ./out < input1.txt'.format(tmp_dir)
    elif lang == 'c':
        cmd = 'cd /tmp/{} && gcc -g -Wall -o out file1.c && ./out < input1.txt'.format(tmp_dir)
    elif lang == 'perl':
        cmd = 'cd /tmp/{} && perl file1.pl'.format(tmp_dir)
    elif lang == 'tcl':
        cmd = 'cd /tmp/{} && tclsh file1.tcl'.format(tmp_dir)
    elif lang == 'go':
        cmd = 'cd /tmp/{} && export GOCACHE=/tmp && go run file1.go'.format(tmp_dir)

    cmd += " && echo '\nProcess done!'"
        
    log = open('/tmp/{}/sim.log'.format(tmp_dir), 'w')
    run_timeout(cmd, t=60, stdout=log, stderr=log)
    #log.close()

    sim_log = "Start to simulate..."
    
    # read sim log
    #sim_log = open('/tmp/{}/sim.log'.format(tmp_dir), 'r').read()
    #sim_log = re.sub(r'\n', '<br>', sim_log)

    # wave path
    #wave_log = ""
    #files = os.listdir('/tmp/{}'.format(tmp_dir))
    #for f in files:
    #    if f.endswith('.vcd'):
    #        file_size = os.path.getsize('/tmp/{}/'.format(tmp_dir) + f)
    #        # vcd is less than 10M
    #        if file_size > 10000000:
    #            wave_log = 'The size of waveform is too large ({})<br>'.format(file_size)
    #        else:
    #            wave_log = '<a href="eda_wave?tmp_dir={}" target="_blank">Open waveform: {}</a><br>'.format(tmp_dir, f)
    
    #data = {'msg': sim_log + wave_log}
    data = {'msg': sim_log}

    return JsonResponse(data, safe=False)


@csrf_exempt
def eda_query_result(request):
    '''
    query sim result incrementally
    '''
    
    # get parammeters from request.POST
    tmp_dir = request.POST.get('tmp_dir')
    lineno = int(request.POST.get('lineno'))
    
    # read sim log
    sim_log = ''
    sim_log_list = open('/tmp/{}/sim.log'.format(tmp_dir), 'r').readlines()
    for i in range(lineno, len(sim_log_list)):
        sim_log += re.sub(r'\n', '<br>', sim_log_list[i])

    sim_done = 0
    last_line = sim_log_list[len(sim_log_list) - 1]
    if last_line.startswith('Process done!'):
        sim_done = 1
    elif last_line.startswith('I give up.'):
        sim_done = 1

    data = {
        'msg': sim_log,
        'sim_done': sim_done
    }
    
    return JsonResponse(data, safe=False)


@csrf_exempt
def eda_check_simulator(request):
    #global p
     
    # get parammeters from request.POST
    #kill = request.POST.get('kill')
     
    ## check and kill
    #status = 'processing'
    #if p.poll() != None:
    #    print('Program has finished!\n')
    #    status = 'exit'
    #elif kill == 'Yes':
    #    p.kill()
    #    status = 'killed'

    status = 'uncheck'
    data = {'status': status}
    return JsonResponse(data, safe=False)


def eda_wave(request):
    '''
    convert vcd to json
    '''
    
    from pyDigitalWaveTools.vcd.parser import VcdParser
    import json

    tmp_dir = request.GET.get('tmp_dir')
    
    files = os.listdir('/tmp/{}'.format(tmp_dir))
    for f in files:
        if f.endswith('.vcd'):
            vcd_file = open('/tmp/{}/{}'.format(tmp_dir, f), "r")
            vcd = VcdParser()
            vcd.parse(vcd_file)
            vcd_json = vcd.scope.toJson()
            vcd_json = vcd_json['children'][0]
            vcd_json_str = json.dumps(vcd_json)

            break
            
    data = {"json_str": vcd_json_str}

    return render(request, 'wave.html', data)

@csrf_exempt
def eda_save_permanet(request):
    t = time.localtime(time.time())
    now = '{:0>4d}-{:0>2d}-{:0>2d} {:0>2d}:{:0>2d}:{:0>2d}'.format(
        t.tm_year, t.tm_mon, t.tm_mday,
        t.tm_hour, t.tm_min, t.tm_sec
    )

    models.edashare.objects.create(
        tmpdir = request.POST.get('tmpdir'),
        author = request.POST.get('author'),
        title = request.POST.get('title'),
        description = request.POST.get('description'),
        code = request.POST.get('file1_base64'),
        lang = request.POST.get('lang'),
        createdate = now
    )
    
    data = {'msg': 'done'}
    return JsonResponse(data, safe=False)

def eda_share_square(request):
    '''
    share square
    '''

    records = models.edashare.objects.all().order_by('-createdate');

    square = []
    for row in records:
        r = {}
        r['tmpdir'] = row.tmpdir
        r['author'] = row.author
        r['title'] = row.title
        r['description'] = row.description
        r['lang'] = row.lang
        r['createdate'] = row.createdate
        square.append(r)
            
    data = {"square": square}

    return render(request, 'share_square.html', data)


def video(request):
    video_db = [
        {
            "video_url" : "https://iccircle.oss-cn-shanghai.aliyuncs.com/iccircle_2021.MP4",
            "video_description": "2021年IC技术圈年会之第一场直播：《IT&IC，软硬件协同发展》"
        },
        {
            "video_url" : "https://iccircle.oss-cn-shanghai.aliyuncs.com/iccircle_eda_online.mp4",
            "video_description": "IC技术圈，在线Verilog仿真平台，功能演示。"
        },
        {
            "video_url" : "https://iccircle.oss-cn-shanghai.aliyuncs.com/cef102_robot.mp4",
            "video_description": "IC技术圈@中国电子展CEF102，机器人表演"
        }
    ]

    vid = request.GET.get('vid', '')
    total = len(video_db)

    if vid == '':
        data = {"video_list": video_db}
        return render(request, 'video_list.html', data)
    elif int(vid) >= total:
        data = {"video_list": video_db}
        return render(request, 'video_list.html', data)
    else:
        data = video_db[int(vid)]
        return render(request, 'video.html', data)        

    
def editor(request):
    data = {}

    id = request.GET.get('id')

    if id and 'logged' in request.session and request.session['logged'] == True:
        temp = models.article.objects.get(id=id)
        data['id'] = temp.id
        data['author'] = temp.author
        data['title'] = temp.title
        data['summary'] = temp.summary
        data['article_md'] = temp.md #base64
    else:
        data['id'] = '0'
        data['author'] = ''
        data['title'] = ''
        data['summary'] = ''
        data['article_md'] = ''
        
    return render(request, 'editor.html', data)

@xframe_options_sameorigin
@csrf_exempt
def editor_upload_image_handle(request):
    image = request.FILES.get('editormd-image-file', None)

    #import time
    t = time.localtime(time.time())
    
    m = re.search(r'\.(\w+)$', image.name)
    suffix = m.group(1)
    
    image_name = "img{:0>4d}{:0>2d}{:0>2d}{:0>2d}{:0>2d}{:0>2d}.{}".format(
        t.tm_year,
        t.tm_mon,
        t.tm_mday,
        t.tm_hour,
        t.tm_min,
        t.tm_sec,
        suffix)
    
    # save image
    save_path = '{}/{}/{}'.format(settings.BASE_DIR, 'static/upload', image_name)
    with open(save_path, 'wb') as f:
        for content in image.chunks():
            f.write(content)

    data = {
        'success': "1",
        'message': "upload success",
        'url': 'https://iccircle.com/static/upload/' + image_name
    }
    
    #return JsonResponse(data, safe=False)
    return JsonResponse(data)


def book(request):
    book_data = models.book.objects.all().order_by('?')
    data = {}
    books = []
    for row in book_data:
        book = {}
        book['id'] = row.id
        book['title'] = row.title
        book['author'] = row.author
        book['description'] = row.description

        # get one comment from book_comment
        book_comment = models.book_comment.objects.filter(book_id=book['id'])

        if book_comment.count() == 0:
            book['have_comment'] = False
        else:
            book['have_comment'] = True
            book['user_id'] = book_comment[0].user_id
            book['comment'] = book_comment[0].comment
            book['comment_createdate'] = book_comment[0].createdate

            # get uname from user by uid
            user = models.user.objects.filter(uid=book['user_id'])
            book['user_name'] = user[0].uname

        books.append(book)
    
    data['books'] = books

    if 'logged' in request.session and request.session['logged'] == True:
        data['logged'] = True
        data['userid'] = request.session['uid']
        data['username'] = request.session['uname']
    else:
        data['logged'] = False
        
    return render(request, 'book.html', data)


def book_add(request):
    data = {}
    return render(request, 'book_add.html', data)


@csrf_exempt
def book_add_handle(request):
    title = request.POST.get('title')
    author = request.POST.get('author')
    imageurl = request.POST.get('imageurl')
    description = request.POST.get('description')
    wxname = request.POST.get('wxname')
    ismember = request.POST.get('ismember')
    
    models.book.objects.create(
        title = title,
        author = author,
        imageurl = imageurl,
        description = description,
        wxname = wxname,
        ismember = ismember
    )

    data = {'msg': "add successfully"}

    return JsonResponse(data, safe=False)    


@csrf_exempt
def book_comment_add(request):
    user_id = request.POST.get('user_id')
    comment = request.POST.get('comment')
    book_id = request.POST.get('book_id')

    t = time.localtime(time.time())
    now = '{:0>4d}-{:0>2d}-{:0>2d} {:0>2d}:{:0>2d}:{:0>2d}'.format(
        t.tm_year, t.tm_mon, t.tm_mday,
        t.tm_hour, t.tm_min, t.tm_sec
    )

    
    models.book_comment.objects.create(
        user_id = user_id,
        comment = comment,
        book_id = book_id,
        createdate = now
    )
    
    data = {"msg": "add successfully"}
    
    return JsonResponse(data, safe=False)


def book_members(request):
    book_data = models.book.objects.filter(ismember=1).order_by('?')
    data = {}
    books = []
    for row in book_data:
        book = {}
        book['id'] = row.id
        book['title'] = row.title
        book['author'] = row.author
        book['description'] = row.description
        book['imageurl'] = row.imageurl
        book['wxname'] = row.wxname

        # get one comment from book_comment
        book_comment = models.book_comment.objects.filter(book_id=book['id'])

        if book_comment.count() == 0:
            book['have_comment'] = False
        else:
            book['have_comment'] = True
            book['user_id'] = book_comment[0].user_id
            book['comment'] = book_comment[0].comment
            book['comment_createdate'] = book_comment[0].createdate

            # get uname from user by uid
            user = models.user.objects.filter(uid=book['user_id'])
            book['user_name'] = user[0].uname

        books.append(book)
    
    data['books'] = books

    if 'logged' in request.session and request.session['logged'] == True:
        data['logged'] = True
        if 'uid' in request.session:
            data['userid'] = request.session['uid']
            data['username'] = request.session['uname']
        else:
            data['logged'] = False
    else:
        data['logged'] = False
        
    return render(request, 'book_members.html', data)


@csrf_exempt
def login_check(request):
    uname = request.POST.get('uname')
    passwd = request.POST.get('passwd')

    user = models.user.objects.filter(uname=uname)
    #for item in user:
    #    print('uid' + item.uid)
    #    print('uname' + item.uname)
    #    print('passwd' + item.passwd
    
    data = {}

    if user.exists() and passwd == user[0].passwd:

        # write session
        request.session['uid'] = user[0].uid
        request.session['uname'] = user[0].uname
        request.session['logged'] = True
        request.session.set_expiry(86400)
        
        data = {
            'msg': 'pass',
            'uid': user[0].uid,
            'uname': user[0].uname
        }
    else:
        data = {
            'msg': 'fail'
        }
        
    return JsonResponse(data, safe=False)


@csrf_exempt
def login_out(request):
    # delete session
    request.session['logged'] = False
    request.session.flush()

    data = {
        'msg': 'logout successfully'
    }

    return JsonResponse(data, safe=False)


def project(request):
    data = {}
    projects = []

    project = {}
    project['id'] = 1
    project['title'] = 'gamegirl'
    project['author'] = 'IC技术圈suisuisi'
    project['description'] = 'This open source project implements a fpga based (Nintendo Entertainment System) nes box.'
    project['url'] = 'https://github.com/iccircle/gamegirl'
    project['status'] = 'Done'
    projects.append(project)

    project = {}
    project['id'] = 2
    project['title'] = 'YASA'
    project['author'] = 'zhajio1988'
    project['description'] = 'YASA is an open source simulation framework for SystemVerilog/UVM testbentch released under the terms of Apache License, v. 2.0. It support mutli_simulators, multi_languages, lsf etc. It support several excellent features. Such as: customized command line arguments, can add any compilation options or simulation options, can running a testcase with random seeds for several rounds or running a group of testcases, each testcase has several command line options.'
    project['url'] = 'https://github.com/zhajio1988/YASA'
    project['status'] = 'Done'
    projects.append(project)

    project = {}
    project['id'] = 3
    project['title'] = 'Open_RegModel'
    project['author'] = 'zhajio1988'
    project['description'] = 'Use ORDT and systemRDL tools to generate C/Verilog header files, register RTL, UVM register models, and docs using SystemRDL.'
    project['url'] = 'https://github.com/zhajio1988/Open_RegModel'
    project['status'] = 'Done'
    projects.append(project)
    
    data['projects'] = projects
    
    return render(request, 'project.html', data)


def page_not_found(request, exception):
    return render(request, '404.html')

def page_error(request):
    return render(request, '500.html')


@csrf_exempt
def friendlink_getall(request):
    data = {}
    friendlinks = []
    
    friendlink_all = models.friendlink.objects.filter(isdel=False).order_by('-idx')

    for row in friendlink_all:
        item = {}
        item['fid'] = row.fid
        item['name'] = row.name
        item['url'] = row.url
        item['logo'] = row.logo
        item['idx'] = row.idx
        friendlinks.append(item)

    data = {
        'friendlinks': friendlinks
    }
        
    return JsonResponse(data, safe=False)


def cef102(request):
    hot = request.GET.get('hot', '0')
    hot_val = int(hot)
    filter_dict = {}
    filter_dict['isdel'] = False
    filter_dict['hot__gte'] = hot_val
    member = models.member.objects.filter(**filter_dict).order_by('-hot', '?')
    #member = models.member.objects.filter(isdel=False).order_by('?')
    #member = models.member.objects.all().order_by('?')
    
    data = {}
    gzh = []
    for row in member:
        item = {}
        item['mid'] = row.mid
        item['name'] = row.name
        item['qrcode'] = row.qrcode
        item['intro'] = row.intro
        item['hot'] = row.hot

        #load author info
        author = models.author.objects.filter(mid=row.mid)
        data = {}
        if author.exists():
            data['empty'] = "no"
            data['author_id'] = author[0].author_id
            data['author_name'] = author[0].author_name
            data['intro'] = author[0].intro
            data['sph_name'] = author[0].sph_name
            data['sph_qrcode'] = author[0].sph_qrcode
            data['zsxq_name'] = author[0].zsxq_name
            data['zsxq_qrcode'] = author[0].zsxq_qrcode
            data['csdn_name'] = author[0].csdn_name
            data['csdn_url'] = author[0].csdn_url
            data['bili_name'] = author[0].bili_name
            data['bili_url'] = author[0].bili_url
            data['blog2_name'] = author[0].blog2_name
            data['blog2_url'] = author[0].blog2_url
            data['toutiao_name'] = author[0].toutiao_name
            data['toutiao_url'] = author[0].toutiao_url
            data['zhihu_name'] = author[0].zhihu_name
            data['zhihu_url'] = author[0].zhihu_url
            data['xhs_name'] = author[0].xhs_name
            data['xhs_url'] = author[0].xhs_url
            data['web_name'] = author[0].web_name
            data['web_url'] = author[0].web_url
            data['other_url1'] = author[0].other_url1
            data['other_url2'] = author[0].other_url2
        else:
            data['empty'] = "yes"
        
        item['no_addition'] = data['empty']
        item['addition_data'] = data
        gzh.append(item)
    num = len(gzh)    
    data = {
        'gzh': gzh,
        'num': num
    }
    
    return render(request, 'cef102.html', data)


@csrf_exempt
def wx_signup(request):
    data = {}

    uname = request.POST.get('username')
    print("uname=", uname)
    count = models.user.objects.filter(uname=uname).count()
    if count != 0:
        data['msg'] = '用户名已存在'
        return JsonResponse(data, safe=False)

    passwd = request.POST.get('pass1')
    models.user.objects.create(
        uname = uname,
        passwd = passwd
    )

    # write session
    request.session['uname'] = uname
    request.session['islogged'] = True
    request.session.set_expiry(86400)
    
    data['msg'] = '注册成功'
    
    return JsonResponse(data, safe=False)


@csrf_exempt
def wx_login(request):
    uname = request.POST.get('username')
    passwd = request.POST.get('pass1')

    temp = models.user.objects.filter(uname=uname)
    
    data = {}

    if temp.exists() and temp[0].passwd == passwd:
        # write session
        request.session['uname'] = uname
        request.session['logged'] = True
        request.session.set_expiry(86400)
        
        data = {
            'msg': '登录成功'
        }
    else:
        data = {
            'msg': '用户名或密码错误'
        }
    
    return JsonResponse(data, safe=False)


@csrf_exempt
def wx_islogin(request):
    data = {}
    if 'logged' in request.session and request.session['logged'] == True and request.session['uname'] == request.POST.get('username'):
        data['msg'] = 'pass'
    else:
        data['msg'] = 'fail'
    
    return JsonResponse(data, safe=False)


@csrf_exempt
def wx_logout(request):
    # delete session
    request.session['logged'] = False
    request.session.flush()

    data = {
        'msg': '退出登录'
    }

    return JsonResponse(data, safe=False)


@csrf_exempt
def wx_get_latest_news(request):
    data = {}
    latest_news = []

    news = models.article.objects.filter(Q(isdel=False) & Q(isprivate=False) & (Q(author='半导体行业快讯') | Q(author='芯片说'))).order_by('-modifydate')

    i = 50
    for row in news:
        if i == 0:
            break
        else:
            i -= 1
        
        item = {}
        item['id'] = row.id
        item['title'] = row.title
        item['author'] = row.author
        item['summary'] = row.summary
        
        # item['createdate'] = row.createdate
        if row.modifydate > row.createdate:
            item['createdate'] = row.modifydate.strftime("%Y-%m-%d %H:%M:%S 修改")
        else:
            item['createdate'] = row.createdate.strftime("%Y-%m-%d %H:%M:%S")

        item['readcnt'] = row.readcnt + row.gzh_readcnt
        item['likecnt'] = row.likecnt
        latest_news.append(item)

    data = {
        'latest_news': latest_news
    }
    
    return JsonResponse(data, safe=False)


@csrf_exempt
def wx_get_all_members(request):
    data = {}
    all_members = []

    data = {
        'all_members': all_members
    }
    
    return JsonResponse(data, safe=False)


@csrf_exempt
def wx_get_articles(request):
    data = {}
    articles = []

    columns = models.article.objects.filter(isdel=False, isprivate=False).order_by('-modifydate')

    author_article_cnt = {}

    i = 50
    #i = 300
    for row in columns:
        if i == 0:
            break
        if row.author != "半导体行业快讯" and row.author != "芯片说":
            #i -= 1

            author = row.author
            if not author in author_article_cnt:
                author_article_cnt[author] = 1
                i -= 1
            elif author_article_cnt[author] >= 10:
            #elif author_article_cnt[author] >= 120:
                continue
            else:
                i -= 1
                author_article_cnt[author] += 1
            
            item = {}
            item['id'] = row.id
            item['title'] = row.title
            item['author'] = row.author
            item['summary'] = row.summary
            
            if row.modifydate > row.createdate:
                item['createdate'] = row.modifydate.strftime("%Y-%m-%d %H:%M:%S 修改")
            else:
                item['createdate'] = row.createdate.strftime("%Y-%m-%d %H:%M:%S")
                
            item['readcnt'] = row.readcnt + row.gzh_readcnt
            item['likecnt'] = row.likecnt
            articles.append(item)

    data = {
        'articles': articles
    }
    
    return JsonResponse(data, safe=False)


@csrf_exempt
def wx_get_articles_by_author(request):
    author = request.GET.get('author')
    data = {}
    
    #get articles
    columns = models.article.objects.filter(isdel=False, isprivate=False, author=author).order_by('-modifydate')
    articles = []
    data['articles'] = articles
    
    for row in columns:

        item = {}
        item['id'] = row.id
        item['title'] = row.title
        item['author'] = row.author
        item['summary'] = row.summary
            
        if row.modifydate > row.createdate:
            item['createdate'] = row.modifydate.strftime("%Y-%m-%d %H:%M:%S 修改")
        else:
            item['createdate'] = row.createdate.strftime("%Y-%m-%d %H:%M:%S")
                
        item['readcnt'] = row.readcnt + row.gzh_readcnt
        item['likecnt'] = row.likecnt
        articles.append(item)

    #get collections
    temp = models.collects.objects.filter(author=request.GET.get('author'))
    collects = []
    data['collects'] = collects

    for res in temp:
        t = {}
        t['id'] = res.id
        t['name'] = res.name
        t['author'] = res.author
        t['intro'] = res.intro
        t['articlelist'] = res.articlelist
        if t['articlelist']:
            t['total'] = len(t['articlelist'].split(','))
        else:
            t['total'] = 0
            
        if t['total'] != 0:
            collects.append(t)
        
    return JsonResponse(data, safe=False)


@csrf_exempt
def wx_get_articles_by_collect(request):
    id = request.GET.get('id')
    data = {}
    
    #get collect info
    temp = models.collects.objects.filter(id=id)

    res = temp[0]
    data['name'] = res.name
    data['author'] = res.author
    data['intro'] = res.intro
    data['articlelist'] = res.articlelist
    data['total'] = 0
    if data['articlelist']:
        articlelist = data['articlelist'].split(',')
        data['total'] = len(articlelist)

        articles = []
        data['articles'] = articles
        for articleid in articlelist:
            article = models.article.objects.filter(id=int(articleid))

            row = article[0]
            item = {}
            item['id'] = row.id
            item['title'] = row.title
            item['author'] = row.author
            item['summary'] = row.summary
            
            if row.modifydate > row.createdate:
                item['createdate'] = row.modifydate.strftime("%Y-%m-%d %H:%M:%S 修改")
            else:
                item['createdate'] = row.createdate.strftime("%Y-%m-%d %H:%M:%S")
                
            item['readcnt'] = row.readcnt + row.gzh_readcnt
            item['likecnt'] = row.likecnt
            articles.append(item)
        
    return JsonResponse(data, safe=False)


def wx_column(request):
    if request.GET.get('id'):
        """show one column article by id"""
        temp_list = models.article.objects.filter(isdel=False, id=request.GET.get('id'))
        
        data = {}
        if temp_list == None or len(temp_list) == 0:
            data['id'] = '0'
            data['author'] = ''
            data['title'] = ''
            data['summary'] = ''
            data['readcnt'] = ''
            data['likecnt'] = ''
            data['createdate'] = ''
            data['article_html'] = ''
        else:
            temp = temp_list[0]
            data['id'] = temp.id

            id_str = 'id_{}'.format(temp.id)
            id_b64byte = base64.b64encode(id_str.encode(encoding='utf-8'))
            id_b64str = id_b64byte.decode('utf-8')
            data['share_url'] = 'https://iccircle.com/column?s=' + id_b64str
            
            data['author'] = temp.author
            data['title'] = temp.title
            data['summary'] = temp.summary
            data['readcnt'] = temp.readcnt + 1 + temp.gzh_readcnt
            data['likecnt'] = temp.likecnt
            data['createdate'] = temp.createdate

            html_base64_str = temp.html

            html_bytes = base64.b64decode(html_base64_str.encode('utf-8'))
            html_str = html_bytes.decode('utf-8')
            data['article_html'] = mark_safe(html_str)
            
            temp.readcnt = temp.readcnt + 1
            temp.save()
        
        return render(request, 'wx_column_detail.html', data)

@csrf_exempt
def wx_like_article(request):
    id = request.GET.get('id')
    data = {}

    articles = models.article.objects.filter(id=id)
    temp = articles[0]
    temp.likecnt = temp.likecnt + 1
    temp.save()

    return JsonResponse(data, safe=False)


@csrf_exempt
def wx_get_user_count(request):
    user_cnt = models.user.objects.filter(uid__gte=88).count()
    data = { 'user_count': user_cnt }
    
    return JsonResponse(data, safe=False)


def ask(request):
    data = {}
    
    return render(request, 'ask.html', data)


@csrf_exempt
def ask_handle(request):
    question = request.POST.get('question')
    
    api_name = "iccircle"
    api_key = "sk-i6OS6LHHCpShpgoRQ4N2dRHaKv06Ijl2xwHuQakAaQfeltSw"

    from openai import OpenAI
    from openai.types.chat.chat_completion import Choice
    
    client = OpenAI(
        api_key = api_key,
        base_url = "https://api.moonshot.cn/v1",
    )

    completion = client.chat.completions.create(
        model = "moonshot-v1-8k",
        messages = [
            {
                "role": "system",
                "content": "你是ASK AI，由Chipeasycloud提供的人工智能助手，你是一位芯片设计专家。Chipeasycloud为专有名词，不可翻译成其他语言。"
            },
            {
                "role": "user",
                "content": question
            }
        ],
        temperature = 0.3,
        #stream=True,
    )

    answer = completion.choices[0].message.content
    data = {"answer": answer}
    return JsonResponse(data, safe=False)

@csrf_exempt
def ask_search(request):
    question = request.POST.get('question')
    
    api_name = "iccircle"
    api_key = "sk-i6OS6LHHCpShpgoRQ4N2dRHaKv06Ijl2xwHuQakAaQfeltSw"
    
    from openai import OpenAI
    from openai.types.chat.chat_completion import Choice

    client = OpenAI(
        api_key = api_key,
        base_url = "https://api.moonshot.cn/v1",
    )
    
    messages = [
        {
            "role": "system",
            "content": "你是ASK AI，由IC技术圈提供的人工智能助手，你是一位芯片设计专家。IC技术圈为专有名词，不可翻译成其他语言。"
        },
        {
            "role": "user",
            "content": f"请联网搜索 {question}，并告诉我它是什么，参考了哪些网页。"}
    ]

    tools = [
	{
	    "type": "builtin_function",
	    "function": {
		"name": "$web_search",
	    },
	},
    ]
    
    def search_impl(arguments):
        return arguments
 
    def chat(messages) -> Choice:
        completion = client.chat.completions.create(
            model="moonshot-v1-128k",
            messages=messages,
            temperature=0.3,
            tools=tools,
        )
        return completion.choices[0]

    finish_reason = None
    while finish_reason is None or finish_reason == "tool_calls":
        choice = chat(messages)
        finish_reason = choice.finish_reason
        if finish_reason == "tool_calls":
            messages.append(choice.message)
            for tool_call in choice.message.tool_calls:
                tool_call_name = tool_call.function.name
                tool_call_arguments = json.loads(tool_call.function.arguments)
                if tool_call_name == "$web_search":
                    tool_result = search_impl(tool_call_arguments)
                else:
                    tool_result = f"Error: unable to find tool by name '{tool_call_name}'"
 
                messages.append({
                    "role": "tool",
                    "tool_call_id": tool_call.id,
                    "name": tool_call_name,
                    "content": json.dumps(tool_result),
                })
    
    answer = choice.message.content
    data = {"answer": answer}
    return JsonResponse(data, safe=False)

def askic(request):
    data = {}
    
    # get data of unresolved
    qst_list = models.question.objects.filter(isdel=False, disabled=False, is_resolved=False).order_by('-updatedate')

    data['unresolved_cnt'] = len(qst_list)

    q1_list = []
    
    i = 10
    for row in qst_list:
        if i == 0:
            break
        else:
            i -= 1
        
        item = {}
        item['id'] = row.id
        item['author'] = 'TEST用户' #row.uid
        item['title'] = row.title
        if row.title == "":
            item['title'] = row.description
        if row.updatedate > row.createdate:
            item['createdate'] = row.modifydate.strftime("%Y-%m-%d %H:%M:%S 修改")
        else:
            item['createdate'] = row.createdate.strftime("%Y-%m-%d %H:%M:%S")

        item['readcnt'] = row.readcnt
        item['likecnt'] = row.likecnt
        item['alsocnt'] = row.alsocnt
        q1_list.append(item)

    data['q1_list'] = q1_list
        
    # get data of resolved
    qst_list = models.question.objects.filter(isdel=False, disabled=False, is_resolved=True).order_by('-updatedate')
    
    data['resolved_cnt'] = len(qst_list)
    
    q2_list = []
    
    i = 10
    for row in qst_list:
        if i == 0:
            break
        else:
            i -= 1
        
        item = {}
        item['id'] = row.id
        item['author'] = 'TEST用户' #row.uid
        item['title'] = row.title
        item['title'] = row.title
        if row.title == "":
            item['title'] = row.description
        if row.updatedate > row.createdate:
            item['createdate'] = row.modifydate.strftime("%Y-%m-%d %H:%M:%S 修改")
        else:
            item['createdate'] = row.createdate.strftime("%Y-%m-%d %H:%M:%S")

        item['readcnt'] = row.readcnt
        item['likecnt'] = row.likecnt
        item['alsocnt'] = row.alsocnt
        q2_list.append(item)

    data['q2_list'] = q2_list
    
    return render(request, 'ask_ic.html', data)

@csrf_exempt
def askic_handle(request):
    t = time.localtime(time.time())
    now = '{:0>4d}-{:0>2d}-{:0>2d} {:0>2d}:{:0>2d}:{:0>2d}'.format(
        t.tm_year, t.tm_mon, t.tm_mday,
        t.tm_hour, t.tm_min, t.tm_sec
    )
    
    models.question.objects.create(
        uid = request.POST.get('uid'),
        title = request.POST.get('title'),
        description = request.POST.get('description'),
        description_base64 = request.POST.get('description_base64'),
        createdate = now,
        updatedate = now
    )

    data = {'msg': "add successfully"}

    return JsonResponse(data, safe=False)


