"""iccircle URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/3.1/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path

from . import views


urlpatterns = [
    path('admin/', admin.site.urls),
    path('', views.index),

    path('ads.txt', views.adstxt),
    path('robots.txt', views.robots),
    path('OyiMLDeh2U.txt', views.OyiMLDeh2U),
    path('xLgZI1o64B.txt', views.xLgZI1o64B),
    path('sitemap.xml', views.sitemap),
    path('BingSiteAuth.xml', views.bingsiteauth),

    path('send_verify_code', views.send_verify_code),
    
    path('thirdparty', views.thirdparty),
    
    path('member', views.member),
    path('member_add', views.member_add),
    path('member_add_handle', views.member_add_handle),
    path('member_update', views.member_update),
    path('member_del', views.member_del),
    path('member_del_handle', views.member_del_handle),

    path('article', views.article),
    path('article_publish', views.article_publish),
    path('columns', views.columns),
    path('columns_latest', views.columns_latest),
    path('columns_signup', views.columns_signup),
    path('columns_signup_handle', views.columns_signup_handle),
    path('columns_login', views.columns_login),
    path('columns_login_check', views.columns_login_check),
    path('columns_login_out', views.columns_login_out),
    path('columns_login_status', views.columns_login_status),
    path('columns_info_update', views.columns_info_update),
    path('column', views.article_column),
    path('column_home', views.column_home),
    path('column_home_edit', views.column_home_edit),
    path('column_article_delete', views.column_article_delete),
    path('column_readcnt', views.column_readcnt),
    path('column_readcnt_update', views.column_readcnt_update),
    
    path('get_rand_4column', views.get_rand_4column),

    path('collect', views.collect),
    path('collect_create', views.collect_create),
    path('collect_edit', views.collect_edit),
    path('collect_append', views.collect_append_id),
    path('collect_remove', views.collect_remove_id),
         
    path('journal', views.journal),
    path('journal_gzh', views.journal_gzh),
    path('selfpost', views.selfpost),
    path('selfpost_add_update', views.selfpost_add_update),
    path('selfpost_delete', views.selfpost_delete),
    path('selfpost_get_by_id', views.selfpost_get_by_id),
    path('journal_detail', views.journal_detail),
    
    path('search', views.search),
    
    path('member_info_update', views.member_info_update),
    path('search_member_id_by_name', views.search_member_id_by_name),
    path('load_gzh_info', views.load_gzh_info),
    path('update_gzh_info', views.update_gzh_info),
    path('author_info_add_update', views.author_info_add_update),
    path('load_author_info', views.load_author_info),
    #path('testrand', view.test_rand_one),
    #path('testadd', view.test_add),

    path('feed', views.gzh_feed_v2),

    path('image', views.image),
    path('image_upload', views.image_upload),
    path('image_upload_handle', views.image_upload_handle),
    path('image_upload_geturl_handle', views.image_upload_geturl_handle),
    path('txtimage', views.txtimage),
    
    path('eda', views.eda),
    path('eda_save_simulate', views.eda_save_simulate),
    path('eda_query_result', views.eda_query_result),
    path('eda_check_simulator', views.eda_check_simulator),
    path('eda_wave', views.eda_wave),
    path('eda_save_permanent', views.eda_save_permanet),
    path('eda_share_square', views.eda_share_square),
    
    path('video', views.video),

    path('editor', views.editor),
    path('editor_upload_image_handle', views.editor_upload_image_handle),

    path('book', views.book),
    path('book_add', views.book_add),
    path('book_add_handle', views.book_add_handle),

    path('book_comment_add', views.book_comment_add),

    path('book_members', views.book_members),
    
    path('login_check', views.login_check),
    path('login_out', views.login_out),
    
    path('project', views.project),

    path('friendlink_getall', views.friendlink_getall),


    path('cef102', views.cef102),

    path('wx_signup', views.wx_signup),
    path('wx_login', views.wx_login),
    path('wx_islogin', views.wx_islogin),    
    path('wx_logout', views.wx_logout),
    path('wx_get_latest_news', views.wx_get_latest_news),
    path('wx_get_all_members', views.wx_get_all_members),
    path('wx_get_articles', views.wx_get_articles),
    path('wx_get_articles_by_author', views.wx_get_articles_by_author),
    path('wx_get_articles_by_collect', views.wx_get_articles_by_collect),
    path('wx_column', views.wx_column),
    path('wx_like_article', views.wx_like_article),
    path('wx_get_user_count', views.wx_get_user_count),
    
    path('ask', views.ask),
    #path('ask_handle', views.ask_handle),
    path('ask_handle', views.ask_search),

    path('askic', views.askic),
    path('askic_handle', views.askic_handle),
    
    #path('translator', views.translator),
    #path('trans_add_page_image', views.trans_add_page_image),
    #path('trans_add_paragraph', views.trans_add_paragraph),
    #path('trans_update_paragraph', views.trans_update_paragraph),
]

handler404 = views.page_not_found
handler500 = views.page_error

