
from django.db import models

class member(models.Model):
    mid = models.AutoField(primary_key=True)
    name = models.CharField(max_length=250)
    qrcode = models.CharField(max_length=250)
    intro = models.TextField()
    tags = models.CharField(max_length=255)
    isdel = models.BooleanField(default=False)
    hot = models.IntegerField(default=0)
    
class journal(models.Model):
    id = models.AutoField(primary_key=True)
    title = models.CharField(max_length=250)
    keywords = models.CharField(max_length=250)
    url = models.CharField(max_length=250)
    wxname = models.CharField(max_length=250)
    year = models.CharField(max_length=20)
    month = models.CharField(max_length=20)
    adddate = models.DateField()
    summary = models.TextField()
    is_del = models.IntegerField()

    class Meta:
        db_table = "journal"
    
class author(models.Model):
    author_id = models.AutoField(primary_key=True)
    author_name = models.CharField(max_length=100)
    intro = models.CharField(max_length=250)
    mid = models.IntegerField()
    sph_name = models.CharField(max_length=250)
    sph_qrcode = models.CharField(max_length=250)
    zsxq_name = models.CharField(max_length=250)
    zsxq_qrcode = models.CharField(max_length=250)
    csdn_name = models.CharField(max_length=250)
    csdn_url = models.CharField(max_length=250)
    bili_name = models.CharField(max_length=250)
    bili_url = models.CharField(max_length=250)
    blog2_name = models.CharField(max_length=250)
    blog2_url = models.CharField(max_length=250)
    toutiao_name = models.CharField(max_length=250)
    toutiao_url = models.CharField(max_length=250)
    zhihu_name = models.CharField(max_length=250)
    zhihu_url = models.CharField(max_length=250)
    xhs_name = models.CharField(max_length=250)
    xhs_url = models.CharField(max_length=250)
    dy_name = models.CharField(max_length=250)
    dy_url = models.CharField(max_length=250)
    web_name = models.CharField(max_length=250)
    web_url = models.CharField(max_length=250)
    other_url1 = models.CharField(max_length=250)
    other_url2 = models.CharField(max_length=250)

    class Meta:
        db_table = "author"
        
class img(models.Model):
    img_id = models.AutoField(primary_key=True)
    img_name = models.CharField(max_length=250)
    img_create_by = models.CharField(max_length=250)
    img_create_on = models.DateTimeField(auto_now=True)
    img_valid_hours = models.IntegerField()

    class Meta:
        db_table = "img"

class edashare(models.Model):
    tmpdir = models.CharField(max_length=250)
    author = models.CharField(max_length=250)
    title = models.CharField(max_length=255)
    description = models.TextField(max_length=10000)
    code = models.TextField(max_length=30000)
    lang = models.CharField(max_length=250)
    createdate = models.DateTimeField()
    
    class Meta:
        db_table = "edashare"
        
class article(models.Model):
    id = models.AutoField(primary_key=True)
    title = models.CharField(max_length=250)
    author = models.CharField(max_length=250)
    summary = models.TextField(max_length=65500)
    md = models.TextField(max_length=65500)
    html = models.TextField(max_length=65500)
    createdate = models.DateTimeField()
    readcnt = models.IntegerField(default=0)
    gzh_readcnt = models.IntegerField(default=0)
    likecnt = models.IntegerField(default=0)
    isprivate = models.BooleanField(default=False)
    isdel = models.BooleanField(default=False)
    modifydate = models.DateTimeField()
    
    class Meta:
        db_table = "article"

class article_comment(models.Model):
    id = models.AutoField(primary_key=True)
    uid = models.IntegerField()
    article_id = models.IntegerField()
    comment_id = models.IntegerField(default=0)
    description = models.TextField(max_length=65500)
    description_base64 = models.TextField(max_length=65500)
    likecnt = models.IntegerField(default=0)
    readcnt = models.IntegerField(default=0)
    isdel = models.BooleanField(default=False)
    disabled = models.BooleanField(default=False)
    createdate = models.DateTimeField()
    updatedate = models.DateTimeField()
    
    class Meta:
        db_table = "article_comment"

# create table `article_comment` (
#     `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
#     `uid` int(10) unsigned NOT NULL,
#     `article_id` int(10) unsigned NOT NULL,
#     `comment_id` int(10) unsigned NOT NULL,
#     `description` text,
#     `description_base64` text,
#     `likecnt` int(10) unsigned NOT NULL DEFAULT 0,
#     `readcnt` int(10) unsigned NOT NULL DEFAULT 0,
#     `isdel` tinyint(1) NOT NULL DEFAULT 0,
#     `disabled` tinyint(1) NOT NULL DEFAULT 0,
#     `createdate` datetime DEFAULT NULL,
#     `updatedate` datetime DEFAULT NULL,
#     PRIMARY KEY(`id`)
# ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

class collects(models.Model):
    id = models.AutoField(primary_key=True)
    name = models.CharField(max_length=250)
    author = models.CharField(max_length=250)
    intro = models.TextField(max_length=2000)
    articlelist = models.TextField(max_length=10000)
    
    class Meta:
        db_table = "collects"

# create table `collects` (
#     `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
#     `name` varchar(250),
#     `author` varchar(250),
#     `intro` text,
#     `articlelist` text,
#     PRIMARY KEY(`id`)
# ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

        
class book(models.Model):
    id = models.AutoField(primary_key=True)
    title = models.CharField(max_length=250)
    author = models.CharField(max_length=250)
    description = models.TextField(max_length=50000)
    imageurl = models.CharField(max_length=250)
    ismember = models.IntegerField()
    wxname = models.CharField(max_length=250)
    
    class Meta:
        db_table = "book"

    
class book_comment(models.Model):
    id = models.AutoField(primary_key=True)
    user_id = models.CharField(max_length=250)
    comment = models.TextField(max_length=50000)
    book_id = models.IntegerField()
    createdate = models.DateTimeField()
    
    class Meta:
        db_table = "book_comment"

class user(models.Model):
    uid = models.AutoField(primary_key=True)
    uname = models.CharField(max_length=100)
    uemail = models.CharField(max_length=100)
    passwd = models.CharField(max_length=250)
    create_dt = models.DateTimeField()
    phone = models.CharField(max_length=30)
    has_column = models.BooleanField(default=False)
    is_email_verified = models.BooleanField(default=False)
    photo = models.CharField(max_length=255)
    is_phone_verified = models.BooleanField(default=False)
    update_dt = models.DateTimeField()

    class Meta:
        db_table = "user"

class friendlink(models.Model):
    fid = models.AutoField(primary_key=True)
    name = models.CharField(max_length=100)
    url = models.CharField(max_length=255)
    logo = models.CharField(max_length=255)
    idx = models.IntegerField()
    isdel = models.BooleanField(default=False)

    class Meta:
        db_table = "friendlink"
    
class columns(models.Model):
    id = models.AutoField(primary_key=True)
    name = models.CharField(max_length=250)
    ismedia = models.BooleanField(default=False)
    intro = models.CharField(max_length=250)
    createdate = models.DateTimeField(auto_now=True)
    pswd = models.CharField(max_length=250)
    is_del = models.BooleanField(default=False)
    iscompany = models.BooleanField(default=False)
    company_name = models.CharField(max_length=250)
    company_fullname = models.CharField(max_length=250)
    company_intro = models.TextField(max_length=65500)
    company_weburl = models.CharField(max_length=255)
    company_gzh_name = models.CharField(max_length=250)
    company_gzh_url = models.CharField(max_length=250)
    logo_url = models.CharField(max_length=250)
    isvip = models.BooleanField(default=False)
    
    class Meta:
        db_table = "columns"
    
        
class question(models.Model):
    id = models.AutoField(primary_key=True)
    uid = models.IntegerField()
    title = models.CharField(max_length=250)
    description = models.TextField(max_length=65500)
    description_base64 = models.TextField(max_length=65500)
    is_resolved = models.BooleanField(default=False)
    alsocnt = models.IntegerField(default=0)
    likecnt = models.IntegerField(default=0)
    readcnt = models.IntegerField(default=0)
    isdel = models.BooleanField(default=False)
    disabled = models.BooleanField(default=False)
    createdate = models.DateTimeField()
    updatedate = models.DateTimeField()
    
    class Meta:
        db_table = "question"

# create table `question` (
#     `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
#     `uid` int(10) unsigned NOT NULL,
#     `title` varchar(250),
#     `description` text,
#     `description_base64` text,
#     `likecnt` int(10) unsigned NOT NULL DEFAULT 0,
#     `readcnt` int(10) unsigned NOT NULL DEFAULT 0,
#     `isdel` tinyint(1) NOT NULL DEFAULT 0,
#     `disabled` tinyint(1) NOT NULL DEFAULT 0,
#     `createdate` datetime DEFAULT NULL,
#     `updatedate` datetime DEFAULT NULL,
#     PRIMARY KEY(`id`)
# ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

class answer(models.Model):
    id = models.AutoField(primary_key=True)
    uid = models.IntegerField()
    question_id = models.IntegerField()
    answer_id = models.IntegerField(default=0)
    description = models.TextField(max_length=65500)
    description_base64 = models.TextField(max_length=65500)
    dislikecnt = models.IntegerField(default=0)
    likecnt = models.IntegerField(default=0)
    readcnt = models.IntegerField(default=0)
    isdel = models.BooleanField(default=False)
    disabled = models.BooleanField(default=False)
    createdate = models.DateTimeField()
    updatedate = models.DateTimeField()
    
    class Meta:
        db_table = "answer"

# create table `answer` (
#     `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
#     `uid` int(10) unsigned NOT NULL,
#     `question_id` int(10) unsigned NOT NULL,
#     `answer_id` int(10) unsigned NOT NULL,
#     `description` text,
#     `description_base64` text,
#     `likecnt` int(10) unsigned NOT NULL DEFAULT 0,
#     `readcnt` int(10) unsigned NOT NULL DEFAULT 0,
#     `isdel` tinyint(1) NOT NULL DEFAULT 0,
#     `disabled` tinyint(1) NOT NULL DEFAULT 0,
#     `createdate` datetime DEFAULT NULL,
#     `updatedate` datetime DEFAULT NULL,
#     PRIMARY KEY(`id`)
# ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

        
